/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.client.render;

import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.config.GraveRenderingConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.events.YigdEvents;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class GraveBlockEntityRenderer
implements BlockEntityRenderer<GraveBlockEntity> {
    private static final Gson GSON = new Gson();
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;
    private final Font textRenderer;
    private final Minecraft client;
    private final boolean adaptRenderer;
    private static ModelPart graveModel;
    @Nullable
    private static TextRenderInfo textRenderInfo;
    @Nullable
    private static SkullRenderInfo skullRenderInfo;
    private static final Map<String, Material> CUBOID_SPRITES;
    private static final RenderType OUTLINE_RENDER_LAYER;
    public static boolean syncedGlowing;
    public static int syncedGlowingMaxDistance;
    public static double syncedDeathSightDistance;

    public GraveBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.skullModels = SkullBlockRenderer.createSkullRenderers((EntityModelSet)context.getModelSet());
        this.textRenderer = context.getFont();
        this.client = Minecraft.getInstance();
        this.adaptRenderer = YigdConfig.getConfig().graveRendering.adaptRenderer;
    }

    public void render(@NotNull GraveBlockEntity entity, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        GraveRenderingConfig config = YigdConfig.getConfig().graveRendering;
        if (!config.useCustomFeatureRenderer) {
            return;
        }
        BlockState state = entity.getBlockState();
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        float rotation = switch (direction) {
            case Direction.SOUTH -> (float)Math.PI;
            case Direction.WEST -> 1.5707964f;
            case Direction.EAST -> 4.712389f;
            default -> 0.0f;
        };
        poseStack.pushPose();
        poseStack.rotateAround(Axis.YP.rotation(rotation), 0.5f, 0.5f, 0.5f);
        if (config.useGlowingEffect && entity.isUnclaimed()) {
            OutlineBufferSource consumerProvider = this.client.levelRenderer.renderBuffers.outlineBufferSource();
            this.renderGlowingOutline(entity, tickDelta, poseStack, (MultiBufferSource)consumerProvider, light, overlay);
        }
        if (config.useSkullRenderer) {
            this.renderOwnerSkull(entity, tickDelta, poseStack, multiBufferSource, light, overlay);
        }
        if (config.useTextRenderer) {
            this.renderGraveText(entity, tickDelta, poseStack, multiBufferSource, light, overlay);
        }
        this.renderGraveModel(entity, tickDelta, poseStack, multiBufferSource, light, overlay);
        poseStack.popPose();
    }

    private void renderOwnerSkull(GraveBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ResolvableProfile skullOwner = entity.getGraveSkull();
        if (skullOwner == null) {
            return;
        }
        SkullBlock.Types type = SkullBlock.Types.PLAYER;
        RenderType renderLayer = SkullBlockRenderer.getRenderType((SkullBlock.Type)type, (ResolvableProfile)skullOwner);
        this.renderSkull(entity, tickDelta, matrices, vertexConsumers, light, overlay, renderLayer);
    }

    private void renderSkull(GraveBlockEntity ignoredEntity, float ignoredTickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int ignoredOverlay, RenderType renderLayer) {
        if (skullRenderInfo == null) {
            return;
        }
        SkullBlock.Types type = SkullBlock.Types.PLAYER;
        SkullModelBase model = this.skullModels.get(type);
        matrices.pushPose();
        matrices.translate(0.5f, 0.25f, 0.5f);
        int[] rotation = GraveBlockEntityRenderer.skullRenderInfo.rotation;
        matrices.translate(0.0, (double)(-(4.0f - GraveBlockEntityRenderer.skullRenderInfo.height)) / 16.0, (double)(-(8.0f - GraveBlockEntityRenderer.skullRenderInfo.depth)) / 16.0);
        Quaternionf angle = new Quaternionf().rotateXYZ((float)Math.toRadians(rotation[0]), (float)Math.toRadians(rotation[1]), (float)Math.toRadians(rotation[2]));
        matrices.mulPose(angle);
        matrices.scale(GraveBlockEntityRenderer.skullRenderInfo.scaleFace, GraveBlockEntityRenderer.skullRenderInfo.scaleFace, GraveBlockEntityRenderer.skullRenderInfo.scaleDepth);
        matrices.translate(-0.5f, -0.25f, -0.5f);
        SkullBlockRenderer.renderSkull(null, (float)0.0f, (float)0.0f, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (SkullModelBase)model, (RenderType)renderLayer);
        matrices.popPose();
    }

    private void renderGraveText(GraveBlockEntity entity, float ignoredTickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int ignoredOverlay) {
        Component graveText = entity.getGraveText();
        if (graveText == null || textRenderInfo == null) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5, (double)(GraveBlockEntityRenderer.textRenderInfo.height / 16.0f), (double)(GraveBlockEntityRenderer.textRenderInfo.depth / 16.0f - 1.0E-4f));
        matrices.scale(-1.0f, -1.0f, 0.0f);
        int textWidth = this.textRenderer.width(graveText.getString());
        float scale = GraveBlockEntityRenderer.textRenderInfo.width / ((float)textWidth * 16.0f);
        matrices.scale(scale, scale, scale);
        matrices.translate((double)(-textWidth) / 2.0, -4.5, 0.0);
        this.textRenderer.drawInBatch(graveText, 0.0f, 0.0f, 0xFFFFFF, false, matrices.last().pose(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
        matrices.popPose();
    }

    private void renderGraveModel(GraveBlockEntity entity, float ignoredTickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        for (Map.Entry<String, Material> cuboid : CUBOID_SPRITES.entrySet()) {
            Level world;
            String key = cuboid.getKey();
            ModelPart part = graveModel.getChild(key);
            if (this.adaptRenderer && key.equals("ground") && (world = entity.getLevel()) != null) {
                BlockPos underPos = entity.getBlockPos().below();
                BlockState blockUnder = entity.getLevel().getBlockState(underPos);
                if (blockUnder != null && blockUnder.isSolidRender((BlockGetter)world, underPos)) {
                    ModelPart.Cube cuboidPart = part.getRandomCube(world.random);
                    float scaleX = cuboidPart.maxX - cuboidPart.minX;
                    float scaleZ = cuboidPart.maxZ - cuboidPart.minZ;
                    matrices.pushPose();
                    matrices.translate(cuboidPart.minX / 16.0f + 5.0E-4f, cuboidPart.maxY / 16.0f - 1.0f, cuboidPart.minZ / 16.0f + 5.0E-4f);
                    matrices.scale(0.999f * (scaleX / 16.0f), 1.0f, 0.999f * (scaleZ / 16.0f));
                    this.client.getBlockRenderer().renderBatched(blockUnder, underPos, (BlockAndTintGetter)world, matrices, vertexConsumers.getBuffer(RenderType.cutout()), false, world.random);
                    matrices.popPose();
                    continue;
                }
            }
            VertexConsumer consumer = cuboid.getValue().buffer(vertexConsumers, RenderType::entityCutout);
            part.render(matrices, consumer, light, overlay);
        }
    }

    private void renderGlowingOutline(GraveBlockEntity entity, float ignoredTickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        LocalPlayer player = this.client.player;
        YigdEvents.RenderGlowingGraveEvent event = (YigdEvents.RenderGlowingGraveEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.RenderGlowingGraveEvent(entity, player));
        if (!event.isRenderGlowing()) {
            return;
        }
        VertexConsumer consumer = vertexConsumers.getBuffer(OUTLINE_RENDER_LAYER);
        graveModel.render(matrices, consumer, light, overlay);
        if (YigdConfig.getConfig().graveRendering.useSkullRenderer) {
            this.renderSkull(entity, ignoredTickDelta, matrices, vertexConsumers, light, overlay, OUTLINE_RENDER_LAYER);
        }
    }

    public static void reloadModelFromJson(JsonObject json) throws IllegalStateException {
        CUBOID_SPRITES.clear();
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        JsonArray textureSize = json.getAsJsonArray("texture_size");
        JsonObject textures = json.getAsJsonObject("textures");
        JsonArray elements = json.getAsJsonArray("elements");
        JsonObject features = json.has("features") ? json.getAsJsonObject("features") : null;
        int uvX = textureSize.get(0).getAsInt();
        int uvY = textureSize.get(1).getAsInt();
        HashMap<String, String> nameIds = new HashMap<String, String>();
        for (Map.Entry e : textures.entrySet()) {
            String key = (String)e.getKey();
            String value = ((JsonElement)e.getValue()).getAsString();
            nameIds.put(key, value);
        }
        int i = 0;
        for (JsonElement e : elements) {
            JsonObject o = e.getAsJsonObject();
            String name = o.has("name") ? o.get("name").getAsString() : String.valueOf(i++);
            JsonArray from = o.getAsJsonArray("from");
            JsonArray to = o.getAsJsonArray("to");
            JsonObject faces = o.getAsJsonObject("faces");
            float minX = Float.MAX_VALUE;
            float minY = Float.MAX_VALUE;
            String textureName = "";
            for (Map.Entry face : faces.entrySet()) {
                JsonObject value = ((JsonElement)face.getValue()).getAsJsonObject();
                JsonArray uv = value.getAsJsonArray("uv");
                textureName = value.get("texture").getAsString();
                minX = Math.min(minX, uv.get(0).getAsFloat());
                minY = Math.min(minY, uv.get(1).getAsFloat());
            }
            minX *= (float)uvX / 16.0f;
            minY *= (float)uvY / 16.0f;
            if (nameIds.containsKey(textureName = textureName.replaceFirst("#", ""))) {
                textureName = (String)nameIds.get(textureName);
            }
            ResourceLocation texture = ResourceLocation.parse((String)textureName);
            Material sprite = new Material(InventoryMenu.BLOCK_ATLAS, texture);
            CUBOID_SPRITES.put(name, sprite);
            float fromX = from.get(0).getAsFloat();
            float fromY = from.get(1).getAsFloat();
            float fromZ = from.get(2).getAsFloat();
            float toX = to.get(0).getAsFloat();
            float toY = to.get(1).getAsFloat();
            float toZ = to.get(2).getAsFloat();
            float lowerX = Math.min(fromX, toX);
            float lowerY = Math.min(fromY, toY);
            float lowerZ = Math.min(fromZ, toZ);
            float higherX = Math.max(fromX, toX);
            float higherY = Math.max(fromY, toY);
            float higherZ = Math.max(fromZ, toZ);
            GraveBlockEntityRenderer.addChildPart(root, name, (int)minX, (int)minY, lowerX, lowerY, lowerZ, higherX - lowerX, higherY - lowerY, higherZ - lowerZ);
        }
        if (features != null) {
            if (features.has("text")) {
                textRenderInfo = (TextRenderInfo)GSON.fromJson(features.get("text"), TextRenderInfo.class);
            }
            if (features.has("skull")) {
                skullRenderInfo = (SkullRenderInfo)GSON.fromJson(features.get("skull"), SkullRenderInfo.class);
            }
        }
        graveModel = LayerDefinition.create((MeshDefinition)modelData, (int)uvX, (int)uvY).bakeRoot();
    }

    private static ModelPart getGraveModel() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        GraveBlockEntityRenderer.addChildPart(root, "ground", 0, 0, 0.0f, 0.0f, 0.0f, 16.0f, 1.0f, 16.0f);
        GraveBlockEntityRenderer.addChildPart(root, "base", 0, 21, 2.0f, 1.0f, 10.0f, 12.0f, 2.0f, 5.0f);
        GraveBlockEntityRenderer.addChildPart(root, "bust", 0, 28, 3.0f, 3.0f, 11.0f, 10.0f, 12.0f, 3.0f);
        GraveBlockEntityRenderer.addChildPart(root, "top", 0, 17, 4.0f, 15.0f, 11.0f, 8.0f, 1.0f, 3.0f);
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64).bakeRoot();
    }

    private static void addChildPart(PartDefinition root, String name, int uvX, int uvY, float minX, float minY, float minZ, float sizeX, float sizeY, float sizeZ) {
        root.addOrReplaceChild(name, CubeListBuilder.create().texOffs(uvX, uvY).addBox(minX, minY, minZ, sizeX, sizeY, sizeZ), PartPose.offsetAndRotation((float)(sizeX + minX * 2.0f), (float)(sizeY + minY * 2.0f), (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.PI)));
    }

    static {
        textRenderInfo = null;
        skullRenderInfo = null;
        CUBOID_SPRITES = new HashMap<String, Material>();
        syncedGlowing = true;
        syncedGlowingMaxDistance = Integer.MAX_VALUE;
        syncedDeathSightDistance = 2.147483647E9;
        graveModel = GraveBlockEntityRenderer.getGraveModel();
        OUTLINE_RENDER_LAYER = RenderType.outline((ResourceLocation)ResourceLocation.parse((String)"textures/misc/white.png"));
    }

    private record SkullRenderInfo(float depth, float height, int[] rotation, float scaleFace, float scaleDepth) {
    }

    private record TextRenderInfo(float depth, float height, float width) {
    }
}

