/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client;

import com.blackgear.vanillabackport.common.registries.ModBiomes;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.mixin.access.SoundEngineAccessor;
import com.blackgear.vanillabackport.core.mixin.access.SoundManagerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.Holder;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class})
public abstract class MusicManagerMixin {
    @Shadow
    @Nullable
    private SoundInstance currentMusic;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private static final float FADE_OUT_FACTOR = 0.97f;
    @Unique
    private static final float FADE_IN_MIN_STEP = 5.0E-4f;
    @Unique
    private static final float FADE_IN_MAX_STEP = 0.005f;
    @Unique
    private static final float VOLUME_THRESHOLD = 1.0E-4f;
    @Unique
    private float currentGain = 1.0f;

    @Shadow
    public abstract void stopPlaying();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTick(CallbackInfo ci) {
        if (!((Boolean)VanillaBackport.CLIENT_CONFIG.fadeMusicOnPaleGarden.get()).booleanValue() || this.currentMusic == null) {
            return;
        }
        float targetVolume = this.getBackgroundMusicVolume();
        if (this.currentGain != targetVolume && this.fadePlaying(targetVolume)) {
            ci.cancel();
        }
    }

    @Inject(method={"startPlaying(Lnet/minecraft/sounds/Music;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPlayingInPaleGarden(Music selector, CallbackInfo ci) {
        if (!((Boolean)VanillaBackport.CLIENT_CONFIG.fadeMusicOnPaleGarden.get()).booleanValue() || this.minecraft.player == null) {
            return;
        }
        Holder biome = this.minecraft.player.level().getBiome(this.minecraft.player.blockPosition());
        if (biome.is(ModBiomes.PALE_GARDEN)) {
            ci.cancel();
        }
    }

    @Inject(method={"startPlaying(Lnet/minecraft/sounds/Music;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;play(Lnet/minecraft/client/resources/sounds/SoundInstance;)V")})
    private void updateVolume(Music selector, CallbackInfo ci) {
        if (((Boolean)VanillaBackport.CLIENT_CONFIG.fadeMusicOnPaleGarden.get()).booleanValue() && this.currentMusic != null) {
            SoundEngine engine = ((SoundManagerAccessor)this.minecraft.getSoundManager()).getSoundEngine();
            this.setVolume(engine, this.currentMusic, this.getBackgroundMusicVolume());
        }
    }

    @Inject(method={"startPlaying(Lnet/minecraft/sounds/Music;)V"}, at={@At(value="TAIL")})
    private void onStartPlaying(Music selector, CallbackInfo ci) {
        if (((Boolean)VanillaBackport.CLIENT_CONFIG.fadeMusicOnPaleGarden.get()).booleanValue()) {
            this.currentGain = this.getBackgroundMusicVolume();
        }
    }

    @Unique
    private boolean fadePlaying(float targetVolume) {
        if (this.currentGain == targetVolume) {
            return true;
        }
        if (this.currentGain < targetVolume) {
            float step = Mth.clamp((float)this.currentGain, (float)5.0E-4f, (float)0.005f);
            this.currentGain = Math.min(this.currentGain + step, targetVolume);
        } else {
            this.currentGain = 0.97f * this.currentGain + 0.029999971f * targetVolume;
            if (Math.abs(this.currentGain - targetVolume) < 1.0E-4f) {
                this.currentGain = targetVolume;
            }
        }
        this.currentGain = Mth.clamp((float)this.currentGain, (float)0.0f, (float)1.0f);
        if (this.currentGain <= 1.0E-4f) {
            this.stopPlaying();
            return false;
        }
        SoundEngine engine = ((SoundManagerAccessor)this.minecraft.getSoundManager()).getSoundEngine();
        this.setVolume(engine, this.currentMusic, this.currentGain);
        return true;
    }

    @Unique
    private float getBackgroundMusicVolume() {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return 1.0f;
        }
        Holder biome = player.level().getBiome(player.blockPosition());
        return biome.is(ModBiomes.PALE_GARDEN) ? 0.0f : 1.0f;
    }

    @Unique
    private void setVolume(SoundEngine engine, SoundInstance instance, float volume) {
        SoundEngineAccessor accessor = (SoundEngineAccessor)engine;
        if (!accessor.isLoaded()) {
            return;
        }
        ChannelAccess.ChannelHandle handle = accessor.getInstanceToChannel().get(instance);
        if (handle != null) {
            handle.execute(channel -> channel.setVolume(volume * accessor.callCalculateVolume(instance)));
        }
    }
}

