/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.registries;

import com.blackgear.platform.core.helper.BlockRegistry;
import com.blackgear.vanillabackport.client.registries.ModParticles;
import com.blackgear.vanillabackport.client.registries.ModSoundTypes;
import com.blackgear.vanillabackport.common.level.blocks.CreakingHeartBlock;
import com.blackgear.vanillabackport.common.level.blocks.DriedGhastBlock;
import com.blackgear.vanillabackport.common.level.blocks.EyeblossomBlock;
import com.blackgear.vanillabackport.common.level.blocks.EyeblossomFlowerPotBlock;
import com.blackgear.vanillabackport.common.level.blocks.HangingMossBlock;
import com.blackgear.vanillabackport.common.level.blocks.MossyCarpetBlock;
import com.blackgear.vanillabackport.common.level.blocks.PaleMossBlock;
import com.blackgear.vanillabackport.common.level.blocks.ParticleLeavesBlock;
import com.blackgear.vanillabackport.common.level.blocks.ResinClumpBlock;
import com.blackgear.vanillabackport.common.registries.ModBlockSetTypes;
import com.blackgear.vanillabackport.common.registries.ModWoodTypes;
import com.blackgear.vanillabackport.common.worldgen.features.TheGardenAwakensFeatures;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModBlocks {
    public static final BlockRegistry BLOCKS = BlockRegistry.create((String)"vanillabackport");
    public static final Supplier<Block> PALE_OAK_LEAVES = BLOCKS.register("pale_oak_leaves", properties -> new ParticleLeavesBlock(50, (Supplier<? extends ParticleOptions>)ModParticles.PALE_OAK_LEAVES, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GREEN).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn((arg_0, arg_1, arg_2, arg_3) -> ((BlockRegistry)BLOCKS).ocelotOrParrot(arg_0, arg_1, arg_2, arg_3)).isSuffocating((arg_0, arg_1, arg_2) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2)).isViewBlocking((arg_0, arg_1, arg_2) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2)).ignitedByLava().pushReaction(PushReaction.DESTROY).isRedstoneConductor((arg_0, arg_1, arg_2) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2)));
    public static final Supplier<Block> PALE_OAK_PLANKS = BLOCKS.register("pale_oak_planks", BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_STAIRS = BLOCKS.register("pale_oak_stairs", properties -> new StairBlock(PALE_OAK_PLANKS.get().defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_SLAB = BLOCKS.register("pale_oak_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_FENCE = BLOCKS.register("pale_oak_fence", FenceBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_FENCE_GATE = BLOCKS.register("pale_oak_fence_gate", properties -> new FenceGateBlock(ModWoodTypes.PALE_OAK, properties), BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_DOOR = BLOCKS.register("pale_oak_door", properties -> new DoorBlock(ModBlockSetTypes.PALE_OAK, properties), BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_OAK_WOOD = BLOCKS.register("pale_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_LOG = BLOCKS.register("pale_oak_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.QUARTZ, MapColor.STONE, SoundType.WOOD));
    public static final Supplier<Block> STRIPPED_PALE_OAK_WOOD = BLOCKS.register("stripped_pale_oak_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava());
    public static final Supplier<Block> STRIPPED_PALE_OAK_LOG = BLOCKS.register("stripped_pale_oak_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.QUARTZ, MapColor.QUARTZ, SoundType.WOOD));
    public static final Supplier<Block> PALE_MOSS_BLOCK = BLOCKS.register("pale_moss_block", PaleMossBlock::new, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(0.1f).sound(SoundType.MOSS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_MOSS_CARPET = BLOCKS.register("pale_moss_carpet", MossyCarpetBlock::new, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(0.1f).sound(SoundType.MOSS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_HANGING_MOSS = BLOCKS.register("pale_hanging_moss", HangingMossBlock::new, BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_LIGHT_GRAY).noCollission().sound(SoundType.MOSS_CARPET).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> OPEN_EYEBLOSSOM = BLOCKS.register("open_eyeblossom", properties -> new EyeblossomBlock(EyeblossomBlock.Type.OPEN, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).randomTicks());
    public static final Supplier<Block> CLOSED_EYEBLOSSOM = BLOCKS.register("closed_eyeblossom", properties -> new EyeblossomBlock(EyeblossomBlock.Type.CLOSED, (BlockBehaviour.Properties)properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).randomTicks());
    public static final Supplier<Block> PALE_OAK_SAPLING = BLOCKS.register("pale_oak_sapling", properties -> new SaplingBlock(new TreeGrower("pale_oak", Optional.of(TheGardenAwakensFeatures.PALE_OAK_BONEMEAL), Optional.empty(), Optional.empty()), properties), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> POTTED_OPEN_EYEBLOSSOM = BLOCKS.registerNoItem("potted_open_eyeblossom", properties -> new EyeblossomFlowerPotBlock(OPEN_EYEBLOSSOM.get(), (BlockBehaviour.Properties)properties), ModBlocks.flowerPotProperties().randomTicks());
    public static final Supplier<Block> POTTED_CLOSED_EYEBLOSSOM = BLOCKS.registerNoItem("potted_closed_eyeblossom", properties -> new EyeblossomFlowerPotBlock(CLOSED_EYEBLOSSOM.get(), (BlockBehaviour.Properties)properties), ModBlocks.flowerPotProperties().randomTicks());
    public static final Supplier<Block> POTTED_PALE_OAK_SAPLING = BLOCKS.registerNoItem("potted_pale_oak_sapling", properties -> new FlowerPotBlock(PALE_OAK_SAPLING.get(), properties), ModBlocks.flowerPotProperties());
    public static final Supplier<Block> CREAKING_HEART = BLOCKS.register("creaking_heart", CreakingHeartBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).strength(10.0f).sound(ModSoundTypes.CREAKING_HEART));
    public static final Pair<Supplier<Block>, Supplier<Block>> PALE_OAK_SIGN = ModBlocks.sign("pale_oak", ModWoodTypes.PALE_OAK, MapColor.QUARTZ);
    public static final Pair<Supplier<Block>, Supplier<Block>> PALE_OAK_HANGING_SIGN = ModBlocks.hangingSign("pale_oak", ModWoodTypes.PALE_OAK, MapColor.QUARTZ);
    public static final Supplier<Block> PALE_OAK_PRESSURE_PLATE = BLOCKS.register("pale_oak_pressure_plate", properties -> new PressurePlateBlock(ModBlockSetTypes.PALE_OAK, properties), BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> PALE_OAK_TRAPDOOR = BLOCKS.register("pale_oak_trapdoor", properties -> new TrapDoorBlock(ModBlockSetTypes.PALE_OAK, properties), BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn((arg_0, arg_1, arg_2, arg_3) -> ((BlockRegistry)BLOCKS).never(arg_0, arg_1, arg_2, arg_3)).ignitedByLava());
    public static final Supplier<Block> PALE_OAK_BUTTON = BLOCKS.register("pale_oak_button", properties -> new ButtonBlock(ModBlockSetTypes.PALE_OAK, 30, properties), ModBlocks.buttonProperties());
    public static final Supplier<Block> RESIN_CLUMP = BLOCKS.register("resin_clump", ResinClumpBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).replaceable().noCollission().sound(ModSoundTypes.RESIN).ignitedByLava().pushReaction(PushReaction.DESTROY));
    public static final Supplier<Block> RESIN_BLOCK = BLOCKS.register("resin_block", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).sound(ModSoundTypes.RESIN));
    public static final Supplier<Block> RESIN_BRICKS = BLOCKS.register("resin_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(ModSoundTypes.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Supplier<Block> RESIN_BRICK_STAIRS = BLOCKS.register("resin_brick_stairs", properties -> new StairBlock(RESIN_BRICKS.get().defaultBlockState(), properties), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(ModSoundTypes.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Supplier<Block> RESIN_BRICK_SLAB = BLOCKS.register("resin_brick_slab", SlabBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(ModSoundTypes.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Supplier<Block> RESIN_BRICK_WALL = BLOCKS.register("resin_brick_wall", WallBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(ModSoundTypes.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Supplier<Block> CHISELED_RESIN_BRICKS = BLOCKS.register("chiseled_resin_bricks", BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().sound(ModSoundTypes.RESIN_BRICKS).strength(1.5f, 6.0f));
    public static final Supplier<Block> DRIED_GHAST = BLOCKS.register("dried_ghast", DriedGhastBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).instabreak().sound(ModSoundTypes.DRIED_GHAST).noOcclusion().randomTicks());

    private static BlockBehaviour.Properties logProperties(MapColor topColor, MapColor sideColor, SoundType sound) {
        return BlockBehaviour.Properties.of().mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : sideColor).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava();
    }

    private static BlockBehaviour.Properties buttonProperties() {
        return BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties flowerPotProperties() {
        return BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY);
    }

    public static Pair<Supplier<Block>, Supplier<Block>> sign(String name, WoodType woodType, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava();
        Supplier standing = BLOCKS.registerNoItem(name + "_sign", () -> new StandingSignBlock(woodType, properties));
        Supplier wall = BLOCKS.registerNoItem(name + "_wall_sign", () -> ModBlocks.lambda$sign$16(woodType, properties, (Supplier)standing));
        BLOCKS.registerItem(name + "_sign", () -> ModBlocks.lambda$sign$17((Supplier)standing, (Supplier)wall));
        return new Pair((Object)standing, (Object)wall);
    }

    public static Pair<Supplier<Block>, Supplier<Block>> hangingSign(String name, WoodType woodType, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava();
        Supplier ceiling = BLOCKS.registerNoItem(name + "_hanging_sign", () -> new CeilingHangingSignBlock(woodType, properties));
        Supplier wall = BLOCKS.registerNoItem(name + "_wall_hanging_sign", () -> ModBlocks.lambda$hangingSign$19(woodType, properties, (Supplier)ceiling));
        BLOCKS.registerItem(name + "_hanging_sign", () -> ModBlocks.lambda$hangingSign$20((Supplier)ceiling, (Supplier)wall));
        return new Pair((Object)ceiling, (Object)wall);
    }

    private static /* synthetic */ Item lambda$hangingSign$20(Supplier ceiling, Supplier wall) {
        return new HangingSignItem((Block)ceiling.get(), (Block)wall.get(), new Item.Properties().stacksTo(16));
    }

    private static /* synthetic */ Block lambda$hangingSign$19(WoodType woodType, BlockBehaviour.Properties properties, Supplier ceiling) {
        return new WallHangingSignBlock(woodType, properties.dropsLike((Block)ceiling.get()));
    }

    private static /* synthetic */ Item lambda$sign$17(Supplier standing, Supplier wall) {
        return new SignItem(new Item.Properties().stacksTo(16), (Block)standing.get(), (Block)wall.get());
    }

    private static /* synthetic */ Block lambda$sign$16(WoodType woodType, BlockBehaviour.Properties properties, Supplier standing) {
        return new WallSignBlock(woodType, properties.dropsLike((Block)standing.get()));
    }
}

