/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.happyghast;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.leash.LeashExtension;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhastAi;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhastTemptGoal;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.blackgear.vanillabackport.core.mixin.access.LivingEntityAccessor;
import com.blackgear.vanillabackport.core.util.BlockPosUtils;
import com.blackgear.vanillabackport.core.util.CollisionUtils;
import com.mojang.serialization.Dynamic;
import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HappyGhast
extends Animal
implements Saddleable,
PlayerRideable,
LeashExtension {
    public static final Ingredient IS_FOOD = Ingredient.of(ModItemTags.HAPPY_GHAST_FOOD);
    private int leashHolderTime = 0;
    private int serverStillTimeout;
    private static final EntityDataAccessor<Boolean> IS_LEASH_HOLDER = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> STAYS_STILL = SynchedEntityData.defineId(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean requiresPrecisePosition;

    public HappyGhast(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new GhastMoveControl(this, true, this::isOnStillTimeout);
        this.lookControl = new HappyGhastLookControl();
    }

    private void setServerStillTimeout(int timeout) {
        this.serverStillTimeout = timeout;
        this.syncStayStillFlag();
    }

    private PathNavigation createBabyNavigation(Level level) {
        return new BabyFlyingPathNavigation((Mob)this, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new GhastFloatGoal(this));
        this.goalSelector.addGoal(4, (Goal)new HappyGhastTemptGoal(this, 1.0, stack -> !this.isSaddled() && !this.isBaby() ? stack.is(ModItemTags.HAPPY_GHAST_TEMPT_ITEMS) : IS_FOOD.test(stack), false, 7.0));
        this.goalSelector.addGoal(5, (Goal)new RandomFloatAroundGoal(this, 16));
    }

    private void adultGhastSetup() {
        this.moveControl = new GhastMoveControl(this, true, this::isOnStillTimeout);
        this.lookControl = new HappyGhastLookControl();
        this.navigation = this.createNavigation(this.level());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.removeAllGoals(goal -> true);
            this.registerGoals();
            this.getBrain().stopAll(server, (LivingEntity)this);
            this.brain.clearMemories();
        }
    }

    private void babyGhastSetup() {
        this.moveControl = new FlyingMoveControl((Mob)this, 180, true);
        this.lookControl = new LookControl((Mob)this);
        this.navigation = this.createBabyNavigation(this.level());
        this.setServerStillTimeout(0);
        this.removeAllGoals(goal -> true);
    }

    protected void ageBoundaryReached() {
        if (this.isBaby()) {
            this.babyGhastSetup();
        } else {
            this.adultGhastSetup();
        }
        super.ageBoundaryReached();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FLYING_SPEED, 0.05).add(Attributes.MOVEMENT_SPEED, 0.05).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    protected float sanitizeScale(float scale) {
        return Math.min(scale, 1.0f);
    }

    public boolean getRequiresPrecisePosition() {
        return this.requiresPrecisePosition;
    }

    public void setRequiresPrecisePosition(boolean requiresPrecisePosition) {
        this.requiresPrecisePosition = requiresPrecisePosition;
    }

    public void stopInPlace() {
        this.getNavigation().stop();
        this.setXxa(0.0f);
        this.setYya(0.0f);
        this.setSpeed(0.0f);
        this.setDeltaMovement(0.0, 0.0, 0.0);
        this.resetAngularMomentum();
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void travel(Vec3 travelVector) {
        if (this.isOnStillTimeout()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        float speed = (float)this.getAttributeValue(Attributes.FLYING_SPEED) * 5.0f / 3.0f;
        if (this.isControlledByLocalInstance()) {
            if (this.isInWater()) {
                this.moveRelative(speed, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(speed, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(speed, travelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    public boolean onClimbable() {
        return false;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        if (!level.isEmptyBlock(pos)) {
            return 0.0f;
        }
        return level.isEmptyBlock(pos.below()) && !level.isEmptyBlock(pos.below(2)) ? 10.0f : 5.0f;
    }

    public boolean canBreatheUnderwater() {
        return this.isBaby() || super.canBreatheUnderwater();
    }

    protected boolean shouldStayCloseToLeashHolder() {
        return false;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public float getVoicePitch() {
        return 1.0f;
    }

    public SoundSource getSoundSource() {
        return SoundSource.NEUTRAL;
    }

    public int getAmbientSoundInterval() {
        int interval = super.getAmbientSoundInterval();
        return this.isVehicle() ? interval * 6 : interval;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.isBaby() ? ModSoundEvents.GHASTLING_AMBIENT.get() : ModSoundEvents.HAPPY_GHAST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return this.isBaby() ? ModSoundEvents.GHASTLING_HURT.get() : ModSoundEvents.HAPPY_GHAST_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return this.isBaby() ? ModSoundEvents.GHASTLING_DEATH.get() : ModSoundEvents.HAPPY_GHAST_DEATH.get();
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mate) {
        return (AgeableMob)ModEntities.HAPPY_GHAST.get().create((Level)level);
    }

    public boolean canFallInLove() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.2375f : 1.0f;
    }

    public boolean isFood(ItemStack stack) {
        return IS_FOOD.test(stack);
    }

    public void equipSaddle(ItemStack stack, @Nullable SoundSource source) {
        this.level().playSound(null, (Entity)this, ModSoundEvents.HARNESS_EQUIP.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby();
    }

    public boolean isSaddled() {
        return this.getItemBySlot(EquipmentSlot.CHEST).is(ModItemTags.HARNESSES);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult result;
        if (this.isBaby()) {
            return super.mobInteract(player, hand);
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!stack.isEmpty() && (result = stack.interactLivingEntity(player, (LivingEntity)this, hand)).consumesAction()) {
            return result;
        }
        if (!stack.is(Items.SHEARS) || this.isVehicle() || !this.isSaddled() && !player.isCreative()) {
            if (this.isSaddled()) {
                if (!this.level().isClientSide()) {
                    player.startRiding((Entity)this);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            return super.mobInteract(player, hand);
        }
        stack.hurtAndBreak(1, (LivingEntity)player, HappyGhast.getSlotForHand((InteractionHand)hand));
        this.playSound(ModSoundEvents.HARNESS_UNEQUIP.get());
        ItemStack harness = this.getItemBySlot(EquipmentSlot.CHEST);
        this.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
        this.spawnAtLocation(harness, this.getBbHeight() + 0.5f);
        return InteractionResult.SUCCESS;
    }

    public AABB getBoundingBoxForCulling() {
        AABB box = super.getBoundingBoxForCulling();
        float height = this.getBbHeight();
        return box.setMinY(box.minY - (double)(height / 2.0f));
    }

    protected void addPassenger(Entity passenger) {
        if (!this.isVehicle()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSoundEvents.HARNESS_GOGGLES_DOWN.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
        super.addPassenger(passenger);
        if (!this.level().isClientSide) {
            if (!this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(0);
            } else if (this.serverStillTimeout > 10) {
                this.setServerStillTimeout(10);
            }
        }
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        if (!this.level().isClientSide) {
            this.setServerStillTimeout(10);
        }
        if (!this.isVehicle()) {
            this.clearRestriction();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSoundEvents.HARNESS_GOGGLES_UP.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    protected boolean canAddPassenger(Entity passenger) {
        return this.getPassengers().size() < 4;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity livingEntity;
        Entity entity;
        if (this.isSaddled() && !this.isOnStillTimeout() && (entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            livingEntity = player;
        } else {
            livingEntity = super.getControllingPassenger();
        }
        return livingEntity;
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        float forward = player.xxa;
        float strafe = 0.0f;
        float upward = 0.0f;
        if (player.zza != 0.0f) {
            float xOffset = Mth.cos((float)(player.getXRot() * ((float)Math.PI / 180)));
            float zOffset = -Mth.sin((float)(player.getXRot() * ((float)Math.PI / 180)));
            if (player.zza < 0.0f) {
                xOffset *= -0.5f;
                zOffset *= -0.5f;
            }
            upward = zOffset;
            strafe = xOffset;
        }
        if (((LivingEntityAccessor)player).isJumping()) {
            upward += 0.5f;
        }
        return new Vec3((double)forward, (double)upward, (double)strafe).scale((double)3.9f * this.getAttributeValue(Attributes.FLYING_SPEED));
    }

    protected Vec2 getRiddenRotation(LivingEntity livingEntity) {
        return new Vec2(livingEntity.getXRot() * 0.5f, livingEntity.getYRot());
    }

    protected void tickRidden(Player player, Vec3 vec3) {
        super.tickRidden(player, vec3);
        Vec2 riddenRotation = this.getRiddenRotation((LivingEntity)player);
        float yRot = this.getYRot();
        float degrees = Mth.wrapDegrees((float)(riddenRotation.y - yRot));
        this.setRot(yRot += degrees * 0.08f, riddenRotation.x);
        this.yBodyRot = this.yHeadRot = yRot;
        this.yRotO = this.yHeadRot;
    }

    protected Brain.Provider<HappyGhast> brainProvider() {
        return HappyGhastAi.brainProvider();
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return HappyGhastAi.makeBrain((Brain<HappyGhast>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<HappyGhast> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        if (this.isBaby()) {
            ProfilerFiller profiler = this.level().getProfiler();
            profiler.push("happyGhastBrain");
            this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
            profiler.popPush("HappyGhastActivityUpdate");
            HappyGhastAi.updateActivity(this);
            profiler.pop();
        }
        this.checkRestriction();
        super.customServerAiStep();
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.leashHolderTime > 0) {
                --this.leashHolderTime;
            }
            this.setLeashHolder(this.leashHolderTime > 0);
            if (this.serverStillTimeout > 0) {
                if (this.tickCount > 60) {
                    --this.serverStillTimeout;
                }
                this.setServerStillTimeout(this.serverStillTimeout);
            }
            if (this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(10);
            }
        }
    }

    public void aiStep() {
        if (!this.level().isClientSide) {
            this.setRequiresPrecisePosition(this.isOnStillTimeout());
        }
        super.aiStep();
        this.continuousHeal();
    }

    private int getHappyGhastRestrictionRadius() {
        return !this.isBaby() && !this.isSaddled() ? 64 : 32;
    }

    private void checkRestriction() {
        if (!this.isLeashed() && !this.isVehicle()) {
            int i = this.getHappyGhastRestrictionRadius();
            if (!this.hasRestriction() || !this.getRestrictCenter().closerThan((Vec3i)this.blockPosition(), (double)(i + 16)) || (float)i != this.getRestrictRadius()) {
                this.restrictTo(this.blockPosition(), i);
            }
        }
    }

    private void continuousHeal() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            boolean canHeal;
            ServerLevel server = (ServerLevel)level;
            if (this.isAlive() && this.deathTime == 0 && this.getMaxHealth() != this.getHealth() && this.tickCount % ((canHeal = server.dimensionType().natural() && (this.isInClouds() || this.precipitationAt(this.blockPosition()) != Biome.Precipitation.NONE)) ? 20 : 600) == 0) {
                this.heal(1.0f);
            }
        }
    }

    private Biome.Precipitation precipitationAt(BlockPos pos) {
        if (!this.level().isRaining()) {
            return Biome.Precipitation.NONE;
        }
        if (!this.level().canSeeSky(pos)) {
            return Biome.Precipitation.NONE;
        }
        if (this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return Biome.Precipitation.NONE;
        }
        Biome biome = (Biome)this.level().getBiome(pos).value();
        return biome.getPrecipitationAt(pos);
    }

    private boolean isInClouds() {
        if (this.level().dimensionType().natural()) {
            int cloudHeight = 192;
            if (this.getY() + (double)this.getBbHeight() < (double)cloudHeight) {
                return false;
            }
            int cloudRange = cloudHeight + 4;
            return this.getY() <= (double)cloudRange;
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_LEASH_HOLDER, (Object)false);
        builder.define(STAYS_STILL, (Object)false);
    }

    private void setLeashHolder(boolean holder) {
        this.entityData.set(IS_LEASH_HOLDER, (Object)holder);
    }

    public boolean isLeashHolder() {
        return (Boolean)this.entityData.get(IS_LEASH_HOLDER);
    }

    private void syncStayStillFlag() {
        this.entityData.set(STAYS_STILL, (Object)(this.serverStillTimeout > 0 ? 1 : 0));
    }

    public boolean staysStill() {
        return (Boolean)this.entityData.get(STAYS_STILL);
    }

    @Override
    public boolean supportQuadLeashAsHolder() {
        return true;
    }

    @Override
    public Vec3[] getQuadLeashHolderOffsets() {
        return LeashExtension.createQuadLeashOffsets((Entity)this, -0.03125, 0.4375, 0.46875, 0.03125);
    }

    protected Vec3 getLeashOffset() {
        return Vec3.ZERO;
    }

    @Override
    public double leashElasticDistance() {
        return 10.0;
    }

    @Override
    public double leashSnapDistance() {
        return 16.0;
    }

    @Override
    public void onElasticLeashPull() {
        LeashExtension.super.onElasticLeashPull();
        this.getMoveControl().operation = MoveControl.Operation.WAIT;
    }

    @Override
    public void notifyLeashHolder(Leashable leashable) {
        if (((LeashExtension)leashable).supportQuadLeash()) {
            this.leashHolderTime = 5;
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("still_timeout", this.serverStillTimeout);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setServerStillTimeout(compound.getInt("still_timeout"));
    }

    public boolean isOnStillTimeout() {
        return this.staysStill() || this.serverStillTimeout > 0;
    }

    private boolean scanPlayerAboveGhast() {
        AABB box = this.getBoundingBox();
        AABB topSurface = new AABB(box.minX - 1.0, box.maxY, box.minZ - 1.0, box.maxX + 1.0, box.maxY + box.getYsize() / 2.0, box.maxZ + 1.0);
        for (Player player : this.level().players()) {
            Entity entity;
            if (player.isSpectator() || (entity = player.getRootVehicle()) instanceof HappyGhast || !topSurface.contains(player.position())) continue;
            return true;
        }
        return false;
    }

    protected BodyRotationControl createBodyControl() {
        return new GhastBodyRotationControl(this);
    }

    public boolean canBeCollidedWith() {
        if (!this.isBaby() && this.isAlive()) {
            return this.isVehicle() || this.isOnStillTimeout();
        }
        return false;
    }

    static class GhastMoveControl
    extends MoveControl {
        private final HappyGhast ghast;
        private int floatDuration;
        private final boolean careful;
        private final BooleanSupplier shouldBeStopped;

        public GhastMoveControl(HappyGhast ghast, boolean careful, BooleanSupplier shouldBeStopped) {
            super((Mob)ghast);
            this.ghast = ghast;
            this.careful = careful;
            this.shouldBeStopped = shouldBeStopped;
        }

        public void tick() {
            if (this.shouldBeStopped.getAsBoolean()) {
                this.operation = MoveControl.Operation.WAIT;
                this.ghast.stopInPlace();
            }
            if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.getRandom().nextInt(5) + 2;
                Vec3 target = new Vec3(this.wantedX - this.ghast.getX(), this.wantedY - this.ghast.getY(), this.wantedZ - this.ghast.getZ());
                if (this.canReach(target)) {
                    this.ghast.setDeltaMovement(this.ghast.getDeltaMovement().add(target.normalize().scale(this.ghast.getAttributeValue(Attributes.FLYING_SPEED) * 5.0 / 3.0)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 target) {
            AABB entityBox = this.ghast.getBoundingBox();
            AABB targetBox = entityBox.move(target);
            if (this.careful) {
                for (BlockPos position : BlockPosUtils.betweenClosed(targetBox.inflate(1.0))) {
                    if (this.blockTraversalPossible((BlockGetter)this.ghast.level(), null, null, position, false, false)) continue;
                    return false;
                }
            }
            boolean inWater = this.ghast.isInWater();
            boolean inLava = this.ghast.isInLava();
            Vec3 currentPos = this.ghast.position();
            Vec3 targetPos = currentPos.add(target);
            return BlockPosUtils.forEachBlockIntersectedBetween(currentPos, targetPos, targetBox, (pos, steps) -> CollisionUtils.intersects(entityBox, pos) || this.blockTraversalPossible((BlockGetter)this.ghast.level(), currentPos, targetPos, pos, inWater, inLava));
        }

        private boolean blockTraversalPossible(BlockGetter level, @Nullable Vec3 origin, @Nullable Vec3 target, BlockPos pos, boolean inWater, boolean inLava) {
            boolean noCollisionDetected;
            boolean hasValidPath;
            BlockState state = level.getBlockState(pos);
            if (state.isAir()) {
                return true;
            }
            boolean bl = hasValidPath = origin != null && target != null;
            boolean bl2 = hasValidPath ? !CollisionUtils.collidedWithShapeMovingFrom((LivingEntity)this.ghast, origin, target, state.getCollisionShape(level, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).toAabbs()) : (noCollisionDetected = state.getCollisionShape(level, pos).isEmpty());
            if (!this.careful) {
                return noCollisionDetected;
            }
            if (state.is(ModBlockTags.HAPPY_GHAST_AVOIDS)) {
                return false;
            }
            FluidState fluidState = level.getFluidState(pos);
            if (!(fluidState.isEmpty() || hasValidPath && !CollisionUtils.collidedWithFluid((LivingEntity)this.ghast, fluidState, pos, origin, target))) {
                if (fluidState.is(FluidTags.WATER)) {
                    return inWater;
                }
                if (fluidState.is(FluidTags.LAVA)) {
                    return inLava;
                }
            }
            return noCollisionDetected;
        }
    }

    class HappyGhastLookControl
    extends LookControl {
        HappyGhastLookControl() {
            super((Mob)HappyGhast.this);
        }

        public void tick() {
            if (HappyGhast.this.isOnStillTimeout()) {
                float degrees = HappyGhastLookControl.wrapDegrees90(HappyGhast.this.getYRot());
                HappyGhast.this.setYRot(HappyGhast.this.getYRot() - degrees);
                HappyGhast.this.setYHeadRot(HappyGhast.this.getYRot());
            } else if (this.lookAtCooldown > 0) {
                --this.lookAtCooldown;
                double x = this.wantedX - HappyGhast.this.getX();
                double z = this.wantedZ - HappyGhast.this.getZ();
                HappyGhast.this.setYRot(-((float)Mth.atan2((double)x, (double)z)) * 57.295776f);
                HappyGhast.this.yHeadRot = HappyGhast.this.yBodyRot = HappyGhast.this.getYRot();
            } else {
                if (HappyGhast.this.isVehicle() && HappyGhast.this.getControllingPassenger() instanceof Player) {
                    return;
                }
                Vec3 motion = this.mob.getDeltaMovement();
                this.mob.setYRot(-((float)Mth.atan2((double)motion.x, (double)motion.z)) * 57.295776f);
                this.mob.yBodyRot = this.mob.getYRot();
            }
        }

        public static float wrapDegrees90(float degrees) {
            float result = degrees % 90.0f;
            if (result >= 45.0f) {
                result -= 90.0f;
            }
            if (result < -45.0f) {
                result += 90.0f;
            }
            return result;
        }
    }

    static class BabyFlyingPathNavigation
    extends FlyingPathNavigation {
        public BabyFlyingPathNavigation(Mob mob, Level level) {
            super(mob, level);
            this.setCanOpenDoors(false);
            this.setCanFloat(true);
        }

        protected boolean canMoveDirectly(Vec3 posVec31, Vec3 posVec32) {
            return BabyFlyingPathNavigation.isClearForMovementBetween((Mob)this.mob, (Vec3)posVec31, (Vec3)posVec32, (boolean)false);
        }
    }

    static class GhastFloatGoal
    extends FloatGoal {
        private final HappyGhast ghast;

        public GhastFloatGoal(HappyGhast ghast) {
            super((Mob)ghast);
            this.ghast = ghast;
        }

        public boolean canUse() {
            return !this.ghast.isOnStillTimeout() && super.canUse();
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final HappyGhast ghast;
        private final int distanceToBlocks;

        public RandomFloatAroundGoal(HappyGhast ghast, int distanceToBlocks) {
            this.ghast = ghast;
            this.distanceToBlocks = distanceToBlocks;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double z;
            double y;
            MoveControl control = this.ghast.getMoveControl();
            if (!control.hasWanted()) {
                return true;
            }
            double x = control.getWantedX() - this.ghast.getX();
            double distance = x * x + (y = control.getWantedY() - this.ghast.getY()) * y + (z = control.getWantedZ() - this.ghast.getZ()) * z;
            return distance < 1.0 || distance > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            Vec3 target = RandomFloatAroundGoal.getSuitableFlyToPosition((Mob)this.ghast, this.distanceToBlocks);
            this.ghast.getMoveControl().setWantedPosition(target.x(), target.y(), target.z(), 1.0);
        }

        public static Vec3 getSuitableFlyToPosition(Mob mob, int distanceToBlocks) {
            BlockPos pos;
            int floor;
            Level level = mob.level();
            RandomSource random = mob.getRandom();
            Vec3 origin = mob.position();
            Vec3 target = null;
            for (int attempt = 0; attempt < 64; ++attempt) {
                target = RandomFloatAroundGoal.chooseRandomPositionWithRestriction(mob, origin, random);
                if (target == null || !RandomFloatAroundGoal.isGoodTarget(level, target, distanceToBlocks)) continue;
                return target;
            }
            if (target == null) {
                target = RandomFloatAroundGoal.chooseRandomPosition(origin, random);
            }
            if ((floor = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (pos = BlockPos.containing(target)).getX(), pos.getZ())) < pos.getY() && floor > level.getMinBuildHeight()) {
                target = new Vec3(target.x(), mob.getY() - Math.abs(mob.getY() - target.y()), target.z());
            }
            return target;
        }

        private static boolean isGoodTarget(Level level, Vec3 target, int distanceToBlocks) {
            if (distanceToBlocks <= 0) {
                return true;
            }
            BlockPos pos = BlockPos.containing((Position)target);
            if (level.getBlockState(pos).isAir()) {
                for (Direction direction : Direction.values()) {
                    for (int distance = 1; distance < distanceToBlocks; ++distance) {
                        BlockPos neighbor = pos.relative(direction, distance);
                        if (level.getBlockState(neighbor).isAir()) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static Vec3 chooseRandomPosition(Vec3 origin, RandomSource random) {
            double x = origin.x() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double y = origin.y() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double z = origin.z() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            return new Vec3(x, y, z);
        }

        @Nullable
        private static Vec3 chooseRandomPositionWithRestriction(Mob mob, Vec3 origin, RandomSource random) {
            Vec3 target = RandomFloatAroundGoal.chooseRandomPosition(origin, random);
            return mob.hasRestriction() && !mob.isWithinRestriction(BlockPos.containing((Position)target)) ? null : target;
        }
    }

    static class GhastBodyRotationControl
    extends BodyRotationControl {
        private final HappyGhast ghast;

        public GhastBodyRotationControl(HappyGhast ghast) {
            super((Mob)ghast);
            this.ghast = ghast;
        }

        public void clientTick() {
            if (this.ghast.isVehicle()) {
                this.ghast.yBodyRot = this.ghast.yHeadRot = this.ghast.getYRot();
            }
            super.clientTick();
        }
    }
}

