/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.magnet;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.filter.IFilter;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.magnet.MagnetWidget;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MagnetUpgrade
extends UpgradeBase<MagnetUpgrade>
implements IFilter,
IEnable,
ITickableUpgrade {
    public ItemStackHandler filter;
    private final MagnetFilterSettings filterSettings;

    public MagnetUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter) {
        super(manager, dataHolderSlot, new Point(66, 103));
        this.filter = this.createFilter(filter);
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get();
        this.filterSettings = new MagnetFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(activeSlotCount).filter(stack -> !stack.isEmpty()).toList(), this.getFilter());
    }

    @Override
    public List<Integer> getFilter() {
        return (List)this.getDataHolderStack().getOrDefault(ModDataComponents.FILTER_SETTINGS, List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    }

    public MagnetFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public void updateSettings() {
        this.filterSettings.updateSettings(this.getFilter());
    }

    @Override
    public int getFilterSlotCount() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new MagnetWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.filterSlotCount.get();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                slots.add((Slot)new FilterSlotItemHandler(this, this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                    @Override
                    public boolean mayPlace(ItemStack pStack) {
                        return menu.getWrapper().isOwner(menu.player) && super.mayPlace(pStack);
                    }
                });
            }
        }
        return slots;
    }

    @Override
    public int getTickRate() {
        return (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.tickRate.get();
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        this.teleportNearbyItems(player, level);
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    public void teleportNearbyItems(Player player, Level level) {
        if (level.isClientSide) {
            return;
        }
        int radius = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.magnetUpgradeSettings.pullRange.get();
        AABB area = new AABB(player.position().add((double)(-radius), (double)(-radius), (double)(-radius)), player.position().add((double)radius, (double)radius, (double)radius));
        List items = level.getEntities((EntityTypeTest)EntityType.ITEM, area, item -> !(!item.isAlive() || level.isClientSide && item.tickCount <= 1 || item.thrower != null && item.thrower.equals(player.getUUID()) && item.tickCount <= 80 || item.getItem().isEmpty() || item.getPersistentData().contains("PreventRemoteMovement") || !this.getFilterSettings().matchesFilter(player, item.getItem())));
        items.forEach(item -> {
            item.setPos(player.getX(), player.getY(), player.getZ());
            item.setNoPickUpDelay();
        });
    }

    private ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                MagnetUpgrade.this.updateDataHolderUnchecked((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), InventoryHelper.itemsToList(this.stacks.size(), MagnetUpgrade.this.filter));
                MagnetUpgrade.this.getFilterSettings().updateFilter((List<ItemStack>)((BackpackContainerContents)MagnetUpgrade.this.getDataHolderStack().get(ModDataComponents.BACKPACK_CONTAINER)).getItems());
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

