/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.ButtonStates;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterButton;
import com.tiviacz.travelersbackpack.network.ServerboundFilterSettingsPacket;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class FeedingWidget
extends UpgradeWidgetBase<FeedingUpgrade> {
    private final FilterButton<FeedingWidget> whitelistButton;
    private final FilterButton<FeedingWidget> hungerModeButton;
    private final FilterButton<FeedingWidget> ignoreEffectModeButton;
    private static final List<Component> WHITELIST_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_allow"), Component.translatable((String)"screen.travelersbackpack.filter_block"));
    private static final List<Component> HUNGER_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_always_eat"), Component.translatable((String)"screen.travelersbackpack.filter_half_nutrition"), Component.translatable((String)"screen.travelersbackpack.filter_full_nutrition"));
    private static final List<Component> IGNORE_MODE_TOOLTIPS = List.of(Component.translatable((String)"screen.travelersbackpack.filter_block_bad_effects"), Component.translatable((String)"screen.travelersbackpack.filter_allow_bad_effects"));

    public FeedingWidget(BackpackScreen screen, FeedingUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 0), "screen.travelersbackpack.feeding_upgrade");
        this.whitelistButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(0), ButtonStates.ALLOW_FEEDING, new Point(pos.x() + 6, pos.y() + 22));
        this.hungerModeButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(1), ButtonStates.HUNGER_MODE, new Point(pos.x() + 6 + 18, pos.y() + 22));
        this.ignoreEffectModeButton = new FilterButton<FeedingWidget>(this, upgrade.getFilter().get(2), ButtonStates.IGNORE_EFFECT_MODE, new Point(pos.x() + 6 + 36, pos.y() + 22));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            this.whitelistButton.renderButton(guiGraphics, mouseX, mouseY);
            this.hungerModeButton.renderButton(guiGraphics, mouseX, mouseY);
            this.ignoreEffectModeButton.renderButton(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isTabOpened()) {
            if (this.whitelistButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), WHITELIST_TOOLTIPS.get(this.whitelistButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.hungerModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), HUNGER_MODE_TOOLTIPS.get(this.hungerModeButton.getCurrentState()), mouseX, mouseY);
            }
            if (this.ignoreEffectModeButton.isMouseOver(mouseX, mouseY)) {
                guiGraphics.renderTooltip(((BackpackScreen)this.screen).getFont(), IGNORE_MODE_TOOLTIPS.get(this.ignoreEffectModeButton.getCurrentState()), mouseX, mouseY);
            }
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isTabOpened() && this.isBackpackOwner()) {
            if (this.whitelistButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.hungerModeButton.getCurrentState()), Integer.valueOf(this.ignoreEffectModeButton.getCurrentState()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.hungerModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.hungerModeButton.getCurrentState()), Integer.valueOf(this.ignoreEffectModeButton.getCurrentState()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
            if (this.ignoreEffectModeButton.mouseClicked(pMouseX, pMouseY, pButton)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundFilterSettingsPacket(this.dataHolderSlot, List.of(Integer.valueOf(this.whitelistButton.getCurrentState()), Integer.valueOf(this.hungerModeButton.getCurrentState()), Integer.valueOf(this.ignoreEffectModeButton.getCurrentState()))), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((BackpackScreen)this.screen).playUIClickSound();
                return true;
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }
}

