/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.datagen;

import com.tiviacz.travelersbackpack.common.recipes.BackpackUpgradeRecipeBuilder;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipeBuilder;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class ModRecipeProvider
extends RecipeProvider {
    public static final Item[] BACKPACKS = new Item[]{(Item)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), (Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.COAL_TRAVELERS_BACKPACK.get(), (Item)ModItems.QUARTZ_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.END_TRAVELERS_BACKPACK.get(), (Item)ModItems.NETHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.SANDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SNOW_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.HAY_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SKELETON_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WARDEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.WOLF_TRAVELERS_BACKPACK.get(), (Item)ModItems.FOX_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.HORSE_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.PIG_TRAVELERS_BACKPACK.get(), (Item)ModItems.SHEEP_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get(), (Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()};

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> holderProvider) {
        super(output, holderProvider);
    }

    protected void buildRecipes(RecipeOutput writer) {
        for (Item item : BACKPACKS) {
            BackpackUpgradeRecipeBuilder.backpackUpgrade(Ingredient.of((TagKey)Tags.Items.LEATHERS), Ingredient.of((ItemLike[])new ItemLike[]{item}), Ingredient.of(ModTags.BACKPACK_UPGRADES), RecipeCategory.MISC, item).unlocks(ModRecipeProvider.getHasName((ItemLike)item), ModRecipeProvider.has((ItemLike)item)).save(writer, ModRecipeProvider.id(ModRecipeProvider.getItemName((ItemLike)item) + "_smithing"));
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get()), (int)4).define(Character.valueOf('A'), Tags.Items.LEATHERS).define(Character.valueOf('B'), Tags.Items.STRINGS).pattern(" B ").pattern("BAB").pattern(" B ").unlockedBy("has_leather", ModRecipeProvider.has((TagKey)Tags.Items.LEATHERS)).save(writer);
        this.createFullGrid((Item)ModItems.IRON_TIER_UPGRADE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_UPGRADE.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Items.IRON_INGOT, (TagKey<Item>)Tags.Items.INGOTS_IRON).save(writer);
        this.createFullGrid((Item)ModItems.GOLD_TIER_UPGRADE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_UPGRADE.get()}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Items.GOLD_INGOT, (TagKey<Item>)Tags.Items.INGOTS_GOLD).save(writer);
        this.createFullGrid((Item)ModItems.DIAMOND_TIER_UPGRADE.get(), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_UPGRADE.get()}), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Items.DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND).save(writer);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.BLANK_UPGRADE.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.NETHERITE_TIER_UPGRADE.get())).unlocks(ModRecipeProvider.getHasName((ItemLike)Items.NETHERITE_INGOT), ModRecipeProvider.has((TagKey)Tags.Items.INGOTS_NETHERITE)).save(writer, ModRecipeProvider.id("netherite_tier_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.TANKS_UPGRADE.get())).define(Character.valueOf('A'), ModItems.BACKPACK_TANK).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).pattern("ABA").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("tanks_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CRAFTING_UPGRADE.get())).define(Character.valueOf('A'), Tags.Items.PLAYER_WORKSTATIONS_CRAFTING_TABLES).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("crafting_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FURNACE_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Blocks.FURNACE).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get()))).save(writer, ModRecipeProvider.id("furnace_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SMOKER_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Blocks.SMOKER).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get()))).save(writer, ModRecipeProvider.id("smoker_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BLAST_FURNACE_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Blocks.BLAST_FURNACE).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).pattern("A").pattern("B").pattern("C").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.BLANK_UPGRADE.get()))).save(writer, ModRecipeProvider.id("blast_furnace_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FEEDING_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), (ItemLike)Items.GOLDEN_APPLE).define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).pattern("ABC").pattern("DDD").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("feeding_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.PICKUP_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.HOPPER).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("pickup_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.JUKEBOX_UPGRADE.get())).define(Character.valueOf('A'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), (ItemLike)Items.JUKEBOX).pattern(" B ").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("jukebox_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.MAGNET_UPGRADE.get())).define(Character.valueOf('A'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('B'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), ModItems.BLANK_UPGRADE).define(Character.valueOf('D'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('E'), Tags.Items.INGOTS_IRON).pattern("A A").pattern("BCD").pattern("BED").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("magnet_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.VOID_UPGRADE.get())).define(Character.valueOf('A'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('B'), (ItemLike)ModItems.BLANK_UPGRADE.get()).define(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName(ModItems.BLANK_UPGRADE), ModRecipeProvider.has(ModItems.BLANK_UPGRADE)).save(writer, ModRecipeProvider.id("void_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.BACKPACK_TANK.get())).define(Character.valueOf('B'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('A'), Tags.Items.INGOTS_IRON).pattern("BAB").pattern("B B").pattern("BAB").unlockedBy("has_iron", ModRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(writer, ModRecipeProvider.id("backpack_tank"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.HOSE_NOZZLE.get())).define(Character.valueOf('A'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), Tags.Items.INGOTS_IRON).pattern(" A ").pattern("B B").unlockedBy("has_iron", ModRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(writer, ModRecipeProvider.id("hose_nozzle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.HOSE.get())).define(Character.valueOf('A'), (ItemLike)ModItems.HOSE_NOZZLE.get()).define(Character.valueOf('B'), Tags.Items.DYES_GREEN).pattern("ABB").pattern("  B").pattern("  B").unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)ModItems.HOSE_NOZZLE.get())), ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.HOSE_NOZZLE.get()))).save(writer, ModRecipeProvider.id("hose"));
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).group("standard_travelers_backpack").define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('C'), (ItemLike)ModItems.BACKPACK_TANK.get()).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.CHESTS_WOODEN).define(Character.valueOf('S'), ModTags.SLEEPING_BAGS).pattern("XBX").pattern("CDC").pattern("XSX").unlockedBy("has_chest", ModRecipeProvider.has((TagKey)Tags.Items.CHESTS_WOODEN)).save(writer, ModRecipeProvider.id("standard"));
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).group("standard_travelers_backpack").define(Character.valueOf('X'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.STRINGS).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.CHESTS_WOODEN).define(Character.valueOf('S'), ModTags.SLEEPING_BAGS).pattern("XBX").pattern(" D ").pattern("XSX").unlockedBy("has_chest", ModRecipeProvider.has((TagKey)Tags.Items.CHESTS_WOODEN)).save(writer, ModRecipeProvider.id("standard_no_tanks"));
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.DIAMOND_TRAVELERS_BACKPACK.get()}), (Ingredient)Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get())).unlocks(ModRecipeProvider.getHasName((ItemLike)Items.NETHERITE_INGOT), ModRecipeProvider.has((TagKey)Tags.Items.INGOTS_NETHERITE)).save(writer, ModRecipeProvider.id("netherite"));
        this.createBackpackSmallGrid((Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), ModRecipeProvider.getHasName((ItemLike)Items.DIAMOND), ModRecipeProvider.has((TagKey)Tags.Items.GEMS_DIAMOND)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), ModRecipeProvider.getHasName((ItemLike)Items.GOLD_INGOT), ModRecipeProvider.has((TagKey)Tags.Items.INGOTS_GOLD)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.GEMS_EMERALD), ModRecipeProvider.getHasName((ItemLike)Items.EMERALD), ModRecipeProvider.has((TagKey)Tags.Items.GEMS_EMERALD)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), ModRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), ModRecipeProvider.has((TagKey)Tags.Items.INGOTS_IRON)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), ModRecipeProvider.getHasName((ItemLike)Items.ENDER_PEARL), ModRecipeProvider.has((TagKey)Tags.Items.ENDER_PEARLS)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.WOLF_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.BONES), ModRecipeProvider.getHasName((ItemLike)Items.BONE), ModRecipeProvider.has((TagKey)Tags.Items.BONES)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.FOX_TRAVELERS_BACKPACK.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.SWEET_BERRIES}), ModRecipeProvider.getHasName((ItemLike)Items.SWEET_BERRIES), ModRecipeProvider.has((ItemLike)Items.SWEET_BERRIES)).save(writer);
        this.createBackpackSmallGrid((Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.COD}), ModRecipeProvider.getHasName((ItemLike)Items.COD), ModRecipeProvider.has((ItemLike)Items.COD)).save(writer);
        this.createBackpackFullGrid((Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE), ModRecipeProvider.getHasName((ItemLike)Items.REDSTONE), ModRecipeProvider.has((TagKey)Tags.Items.DUSTS_REDSTONE)).save(writer);
        this.createBackpackFullGrid((Item)ModItems.COAL_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)ItemTags.COALS), ModRecipeProvider.getHasName((ItemLike)Items.COAL), ModRecipeProvider.has((TagKey)ItemTags.COALS)).save(writer);
        this.createBackpackFullGrid((Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), Ingredient.of((ItemLike[])new ItemLike[]{Items.SPONGE}), ModRecipeProvider.getHasName((ItemLike)Items.SPONGE), ModRecipeProvider.has((ItemLike)Items.SPONGE)).save(writer);
        this.createBackpackFullGrid((Item)ModItems.HAY_TRAVELERS_BACKPACK.get(), Ingredient.of((TagKey)Tags.Items.CROPS_WHEAT), ModRecipeProvider.getHasName((ItemLike)Items.WHEAT), ModRecipeProvider.has((TagKey)Tags.Items.CROPS_WHEAT)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.BEE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.HONEYCOMB).define(Character.valueOf('B'), (ItemLike)Items.HONEY_BOTTLE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.HONEYCOMB), ModRecipeProvider.has((ItemLike)Items.HONEYCOMB)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.HONEY_BOTTLE), ModRecipeProvider.has((ItemLike)Items.HONEY_BOTTLE)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.BLAZE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.RODS_BLAZE).define(Character.valueOf('B'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('E'), (ItemLike)Items.LAVA_BUCKET).pattern("ABA").pattern("ACA").pattern("DED").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.BLAZE_ROD), ModRecipeProvider.has((TagKey)Tags.Items.RODS_BLAZE)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("BCB").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.BOOK), ModRecipeProvider.has((ItemLike)Items.BOOK)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.CACTUS_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.CACTUS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.DYES_GREEN).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.SANDS).pattern("ABA").pattern("ACA").pattern("DDD").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CACTUS), ModRecipeProvider.has((ItemLike)Items.CACTUS)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.CAKE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.MILK_BUCKET).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.EGGS).define(Character.valueOf('C'), (ItemLike)Items.SUGAR).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('E'), (TagKey<Item>)Tags.Items.CROPS_WHEAT).pattern("ABA").pattern("CDC").pattern("EEE").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.EGG), ModRecipeProvider.has((TagKey)Tags.Items.EGGS)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.FEATHERS).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.EGGS).pattern(" A ").pattern("ABA").pattern("CCC").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.FEATHER), ModRecipeProvider.has((TagKey)Tags.Items.FEATHERS)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.COW_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.BEEF).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.MILK_BUCKET).pattern("ABA").pattern("ACA").pattern("BDB").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MILK_BUCKET), ModRecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.CREEPER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.GUNPOWDER).define(Character.valueOf('B'), (ItemLike)Items.CREEPER_HEAD).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.TNT).pattern("ABA").pattern("ACA").pattern("DDD").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.GUNPOWDER), ModRecipeProvider.has((ItemLike)Items.GUNPOWDER)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.DRAGON_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.DRAGON_BREATH).define(Character.valueOf('B'), (ItemLike)Items.DRAGON_HEAD).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.END_STONES).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('E'), (TagKey<Item>)Tags.Items.ENDER_PEARLS).pattern("ABA").pattern("CDC").pattern("ECE").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.DRAGON_BREATH), ModRecipeProvider.has((ItemLike)Items.DRAGON_BREATH)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.END_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.END_STONES).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.ENDER_EYE), ModRecipeProvider.has((ItemLike)Items.ENDER_EYE)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.GHAST_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('B'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.GUNPOWDERS).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("CDC").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.GHAST_TEAR), ModRecipeProvider.has((ItemLike)Items.GHAST_TEAR)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.HORSE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.LEATHERS).define(Character.valueOf('B'), (ItemLike)Items.APPLE).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.CROPS_WHEAT).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("CDC").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.LEATHER), ModRecipeProvider.has((ItemLike)Items.LEATHER)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.LAPIS_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.GEMS_LAPIS).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.LAPIS_LAZULI), ModRecipeProvider.has((TagKey)Tags.Items.GEMS_LAPIS)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.MAGMA_CREAM).define(Character.valueOf('B'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("ACA").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MAGMA_CREAM), ModRecipeProvider.has((ItemLike)Items.MAGMA_CREAM)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.MELON_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.MELON_SLICE).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('C'), (ItemLike)Items.MELON_SEEDS).pattern("A A").pattern("ABA").pattern("ACA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.MELON_SLICE), ModRecipeProvider.has((ItemLike)Items.MELON_SLICE)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.NETHER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (TagKey<Item>)Tags.Items.GEMS_QUARTZ).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.CROPS_NETHER_WART).define(Character.valueOf('C'), (TagKey<Item>)Tags.Items.NETHERRACKS).define(Character.valueOf('D'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('E'), (ItemLike)Items.BLACKSTONE).define(Character.valueOf('F'), (ItemLike)Items.LAVA_BUCKET).pattern("ABA").pattern("CDC").pattern("EFE").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.NETHER_WART), ModRecipeProvider.has((TagKey)Tags.Items.CROPS_NETHER_WART)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.PIG_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.PORKCHOP).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.CROPS_CARROT).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("ACA").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.PORKCHOP), ModRecipeProvider.has((ItemLike)Items.PORKCHOP)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.PUMPKIN).define(Character.valueOf('B'), (ItemLike)Items.CARVED_PUMPKIN).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (TagKey<Item>)Tags.Items.SEEDS_PUMPKIN).pattern("ABA").pattern("ACA").pattern("ADA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.PUMPKIN), ModRecipeProvider.has((ItemLike)Items.PUMPKIN)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.QUARTZ_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.QUARTZ_BLOCK).define(Character.valueOf('B'), (TagKey<Item>)Tags.Items.GEMS_QUARTZ).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.QUARTZ), ModRecipeProvider.has((TagKey)Tags.Items.GEMS_QUARTZ)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.SANDSTONE_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.SANDSTONE).define(Character.valueOf('B'), (ItemLike)Items.CHISELED_SANDSTONE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("ACA").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.SANDSTONE), ModRecipeProvider.has((ItemLike)Items.SANDSTONE)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.SHEEP_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.WHITE_WOOL).define(Character.valueOf('B'), (ItemLike)Items.MUTTON).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.WHITE_WOOL), ModRecipeProvider.has((ItemLike)Items.WHITE_WOOL)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.SKELETON_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.BONE).define(Character.valueOf('B'), (ItemLike)Items.ARROW).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.BOW).pattern("ABA").pattern("BCB").pattern("ADA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.ARROW), ModRecipeProvider.has((ItemLike)Items.ARROW)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.SNOW_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.ICE).define(Character.valueOf('B'), (ItemLike)Items.SNOW_BLOCK).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).define(Character.valueOf('D'), (ItemLike)Items.SNOWBALL).pattern("AAA").pattern("BCB").pattern("DBD").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.SNOWBALL), ModRecipeProvider.has((ItemLike)Items.SNOWBALL)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.SPIDER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.SPIDER_EYE).define(Character.valueOf('B'), (ItemLike)Items.STRING).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.STRING), ModRecipeProvider.has((ItemLike)Items.STRING)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.SQUID_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.GLOW_INK_SAC).define(Character.valueOf('B'), (ItemLike)Items.INK_SAC).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("ABA").pattern("BCB").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.INK_SAC), ModRecipeProvider.has((ItemLike)Items.INK_SAC)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.WITHER_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.WITHER_SKELETON_SKULL).define(Character.valueOf('B'), (ItemLike)Items.SOUL_SAND).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("BCB").pattern(" B ").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.WITHER_SKELETON_SKULL), ModRecipeProvider.has((ItemLike)Items.WITHER_SKELETON_SKULL)).save(writer);
        ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)ModItems.WARDEN_TRAVELERS_BACKPACK.get()).define(Character.valueOf('A'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('B'), (ItemLike)Items.WARD_ARMOR_TRIM_SMITHING_TEMPLATE).define(Character.valueOf('C'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("ACA").pattern("ABA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.ECHO_SHARD), ModRecipeProvider.has((ItemLike)Items.ECHO_SHARD)).save(writer);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.BLACK_SLEEPING_BAG.get(), (ItemLike)Items.BLACK_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.BLUE_SLEEPING_BAG.get(), (ItemLike)Items.BLUE_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.BROWN_SLEEPING_BAG.get(), (ItemLike)Items.BROWN_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.CYAN_SLEEPING_BAG.get(), (ItemLike)Items.CYAN_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.GRAY_SLEEPING_BAG.get(), (ItemLike)Items.GRAY_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.GREEN_SLEEPING_BAG.get(), (ItemLike)Items.GREEN_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.LIGHT_BLUE_SLEEPING_BAG.get(), (ItemLike)Items.LIGHT_BLUE_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.LIGHT_GRAY_SLEEPING_BAG.get(), (ItemLike)Items.LIGHT_GRAY_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.LIME_SLEEPING_BAG.get(), (ItemLike)Items.LIME_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.MAGENTA_SLEEPING_BAG.get(), (ItemLike)Items.MAGENTA_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.ORANGE_SLEEPING_BAG.get(), (ItemLike)Items.ORANGE_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.PINK_SLEEPING_BAG.get(), (ItemLike)Items.PINK_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.PURPLE_SLEEPING_BAG.get(), (ItemLike)Items.PURPLE_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.RED_SLEEPING_BAG.get(), (ItemLike)Items.RED_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.WHITE_SLEEPING_BAG.get(), (ItemLike)Items.WHITE_WOOL);
        ModRecipeProvider.sleepingBagFromWool(writer, (ItemLike)ModItems.YELLOW_SLEEPING_BAG.get(), (ItemLike)Items.YELLOW_WOOL);
        List<Item> list = List.of(Items.BLACK_DYE, Items.BLUE_DYE, Items.BROWN_DYE, Items.CYAN_DYE, Items.GRAY_DYE, Items.GREEN_DYE, Items.LIGHT_BLUE_DYE, Items.LIGHT_GRAY_DYE, Items.LIME_DYE, Items.MAGENTA_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.PURPLE_DYE, Items.RED_DYE, Items.YELLOW_DYE, Items.WHITE_DYE);
        List<Item> list2 = List.of((Item)ModItems.BLACK_SLEEPING_BAG.get(), (Item)ModItems.BLUE_SLEEPING_BAG.get(), (Item)ModItems.BROWN_SLEEPING_BAG.get(), (Item)ModItems.CYAN_SLEEPING_BAG.get(), (Item)ModItems.GRAY_SLEEPING_BAG.get(), (Item)ModItems.GREEN_SLEEPING_BAG.get(), (Item)ModItems.LIGHT_BLUE_SLEEPING_BAG.get(), (Item)ModItems.LIGHT_GRAY_SLEEPING_BAG.get(), (Item)ModItems.LIME_SLEEPING_BAG.get(), (Item)ModItems.MAGENTA_SLEEPING_BAG.get(), (Item)ModItems.ORANGE_SLEEPING_BAG.get(), (Item)ModItems.PINK_SLEEPING_BAG.get(), (Item)ModItems.PURPLE_SLEEPING_BAG.get(), (Item)ModItems.RED_SLEEPING_BAG.get(), (Item)ModItems.YELLOW_SLEEPING_BAG.get(), (Item)ModItems.WHITE_SLEEPING_BAG.get());
        ModRecipeProvider.colorBlockWithDye(writer, list, list2, "sleeping_bag");
    }

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)name);
    }

    protected static void sleepingBagFromWool(RecipeOutput recipeOutput, ItemLike sleepingBag, ItemLike pWool) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)sleepingBag).group("sleeping_bag").define(Character.valueOf('#'), pWool).define(Character.valueOf('X'), (ItemLike)Items.WHITE_WOOL).pattern("##X").unlockedBy(ModRecipeProvider.getHasName((ItemLike)pWool), ModRecipeProvider.has((ItemLike)pWool)).save(recipeOutput);
    }

    protected static void colorBlockWithDye(RecipeOutput recipeOutput, List<Item> pDyes, List<Item> pDyeableItems, String pGroup) {
        for (int i = 0; i < pDyes.size(); ++i) {
            Item item = pDyes.get(i);
            Item item1 = pDyeableItems.get(i);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item1).requires((ItemLike)item).requires(Ingredient.of(pDyeableItems.stream().filter(p_288265_ -> !p_288265_.equals(item1)).map(ItemStack::new))).group(pGroup).unlockedBy("has_needed_dye", ModRecipeProvider.has((ItemLike)item)).save(recipeOutput, ModRecipeProvider.id("dye_" + ModRecipeProvider.getItemName((ItemLike)item1)));
        }
    }

    public ShapedBackpackRecipeBuilder createBackpackSmallGrid(Item result, Ingredient ingredient, String criterionName, Criterion<?> criterion) {
        return ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('A'), ingredient).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern(" A ").pattern("ABA").pattern(" A ").unlockedBy(criterionName, (Criterion)criterion);
    }

    public ShapedBackpackRecipeBuilder createBackpackFullGrid(Item result, Ingredient ingredient, String criterionName, Criterion<?> criterion) {
        return ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('A'), ingredient).define(Character.valueOf('B'), (ItemLike)ModItems.STANDARD_TRAVELERS_BACKPACK.get()).pattern("AAA").pattern("ABA").pattern("AAA").unlockedBy(criterionName, (Criterion)criterion);
    }

    public ShapedBackpackRecipeBuilder createFullGrid(Item result, Ingredient ingredient, Ingredient ingredient1, Item unlocker, TagKey<Item> tag) {
        return ShapedBackpackRecipeBuilder.shaped(RecipeCategory.MISC, (ItemLike)result).define(Character.valueOf('A'), ingredient1).define(Character.valueOf('B'), ingredient).pattern("AAA").pattern("ABA").pattern("AAA").unlockedBy(ModRecipeProvider.getHasName((ItemLike)unlocker), ModRecipeProvider.has(tag));
    }
}

