/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.blocks;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TravelersBackpackBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape BACKPACK_TANKS_SHAPE_NORTH = Stream.of(Block.box((double)4.1, (double)0.8, (double)7.1, (double)11.9, (double)7.8, (double)11.0), Block.box((double)4.1, (double)7.8, (double)7.1, (double)11.9, (double)10.1, (double)11.0), Block.box((double)4.1, (double)0.0, (double)7.9, (double)11.9, (double)0.8, (double)11.0), Block.box((double)4.9, (double)2.4, (double)5.5, (double)11.1, (double)7.1, (double)7.1), Block.box((double)10.4, (double)1.6, (double)11.0, (double)11.2, (double)7.8, (double)11.8), Block.box((double)4.8, (double)1.6, (double)11.0, (double)5.6, (double)7.8, (double)11.8), Block.box((double)1.0, (double)0.0, (double)7.4, (double)4.1, (double)7.8, (double)10.5), Block.box((double)11.9, (double)0.0, (double)7.4, (double)15.0, (double)7.8, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape BACKPACK_TANKS_SHAPE_EAST = Stream.of(Block.box((double)5.0, (double)0.8, (double)4.1, (double)8.9, (double)7.8, (double)11.9), Block.box((double)5.0, (double)7.8, (double)4.1, (double)8.9, (double)10.1, (double)11.9), Block.box((double)5.0, (double)0.0, (double)4.1, (double)5.9, (double)0.8, (double)11.9), Block.box((double)8.9, (double)2.4, (double)4.9, (double)10.5, (double)7.1, (double)11.1), Block.box((double)4.2, (double)1.6, (double)4.8, (double)5.0, (double)7.8, (double)5.6), Block.box((double)4.2, (double)1.6, (double)10.4, (double)5.0, (double)7.8, (double)11.2), Block.box((double)5.5, (double)0.0, (double)1.0, (double)8.6, (double)7.8, (double)4.1), Block.box((double)5.5, (double)0.0, (double)11.9, (double)8.6, (double)7.8, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape BACKPACK_TANKS_SHAPE_SOUTH = Stream.of(Block.box((double)4.1, (double)0.8, (double)5.0, (double)11.9, (double)7.8, (double)8.9), Block.box((double)4.1, (double)7.8, (double)5.0, (double)11.9, (double)10.1, (double)8.9), Block.box((double)4.1, (double)0.0, (double)5.0, (double)11.9, (double)0.8, (double)8.1), Block.box((double)4.9, (double)2.4, (double)8.9, (double)11.1, (double)7.1, (double)10.5), Block.box((double)4.8, (double)1.6, (double)4.2, (double)5.6, (double)7.8, (double)5.0), Block.box((double)10.4, (double)1.6, (double)4.2, (double)11.2, (double)7.8, (double)5.0), Block.box((double)1.0, (double)0.0, (double)5.5, (double)4.1, (double)7.8, (double)8.6), Block.box((double)11.9, (double)0.0, (double)5.5, (double)15.0, (double)7.8, (double)8.6)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape BACKPACK_TANKS_SHAPE_WEST = Stream.of(Block.box((double)7.1, (double)0.8, (double)4.1, (double)11.0, (double)7.8, (double)11.9), Block.box((double)7.1, (double)7.8, (double)4.1, (double)11.0, (double)10.1, (double)11.9), Block.box((double)7.9, (double)0.0, (double)4.1, (double)11.0, (double)0.8, (double)11.9), Block.box((double)5.5, (double)2.4, (double)4.9, (double)7.1, (double)7.1, (double)11.1), Block.box((double)11.0, (double)1.6, (double)10.4, (double)11.8, (double)7.8, (double)11.2), Block.box((double)11.0, (double)1.6, (double)4.8, (double)11.8, (double)7.8, (double)5.6), Block.box((double)7.4, (double)0.0, (double)1.0, (double)10.5, (double)7.8, (double)4.1), Block.box((double)7.4, (double)0.0, (double)11.9, (double)10.5, (double)7.8, (double)15.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape BACKPACK_SHAPE_NORTH = Stream.of(Block.box((double)4.1, (double)0.8, (double)7.1, (double)11.9, (double)7.8, (double)11.0), Block.box((double)4.1, (double)7.8, (double)7.1, (double)11.9, (double)10.1, (double)11.0), Block.box((double)4.1, (double)0.0, (double)7.9, (double)11.9, (double)0.8, (double)11.0), Block.box((double)4.9, (double)2.4, (double)5.5, (double)11.1, (double)7.1, (double)7.1), Block.box((double)10.4, (double)1.6, (double)11.0, (double)11.2, (double)7.8, (double)11.8), Block.box((double)4.8, (double)1.6, (double)11.0, (double)5.6, (double)7.8, (double)11.8)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape BACKPACK_SHAPE_EAST = Stream.of(Block.box((double)5.0, (double)0.8, (double)4.1, (double)8.9, (double)7.8, (double)11.9), Block.box((double)5.0, (double)7.8, (double)4.1, (double)8.9, (double)10.1, (double)11.9), Block.box((double)5.0, (double)0.0, (double)4.1, (double)5.9, (double)0.8, (double)11.9), Block.box((double)8.9, (double)2.4, (double)4.9, (double)10.5, (double)7.1, (double)11.1), Block.box((double)4.2, (double)1.6, (double)4.8, (double)5.0, (double)7.8, (double)5.6), Block.box((double)4.2, (double)1.6, (double)10.4, (double)5.0, (double)7.8, (double)11.2)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape BACKPACK_SHAPE_SOUTH = Stream.of(Block.box((double)4.1, (double)0.8, (double)5.0, (double)11.9, (double)7.8, (double)8.9), Block.box((double)4.1, (double)7.8, (double)5.0, (double)11.9, (double)10.1, (double)8.9), Block.box((double)4.1, (double)0.0, (double)5.0, (double)11.9, (double)0.8, (double)8.1), Block.box((double)4.9, (double)2.4, (double)8.9, (double)11.1, (double)7.1, (double)10.5), Block.box((double)4.8, (double)1.6, (double)4.2, (double)5.6, (double)7.8, (double)5.0), Block.box((double)10.4, (double)1.6, (double)4.2, (double)11.2, (double)7.8, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape BACKPACK_SHAPE_WEST = Stream.of(Block.box((double)7.1, (double)0.8, (double)4.1, (double)11.0, (double)7.8, (double)11.9), Block.box((double)7.1, (double)7.8, (double)4.1, (double)11.0, (double)10.1, (double)11.9), Block.box((double)7.9, (double)0.0, (double)4.1, (double)11.0, (double)0.8, (double)11.9), Block.box((double)5.5, (double)2.4, (double)4.9, (double)7.1, (double)7.1, (double)11.1), Block.box((double)11.0, (double)1.6, (double)10.4, (double)11.8, (double)7.8, (double)11.2), Block.box((double)11.0, (double)1.6, (double)4.8, (double)11.8, (double)7.8, (double)5.6)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public TravelersBackpackBlock(BlockBehaviour.Properties builder) {
        super(builder.strength(1.0f, Float.MAX_VALUE).forceSolidOn().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean hasTanks = false;
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            hasTanks = backpackBlockEntity.getWrapper().tanksVisible();
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_SOUTH;
                }
                yield BACKPACK_SHAPE_SOUTH;
            }
            case Direction.EAST -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_EAST;
                }
                yield BACKPACK_SHAPE_EAST;
            }
            case Direction.WEST -> {
                if (hasTanks) {
                    yield BACKPACK_TANKS_SHAPE_WEST;
                }
                yield BACKPACK_SHAPE_WEST;
            }
            default -> hasTanks ? BACKPACK_TANKS_SHAPE_NORTH : BACKPACK_SHAPE_NORTH;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ((BackpackBlockEntity)level.getBlockEntity(pos)).openBackpack(player, (BackpackBlockEntity)level.getBlockEntity(pos), pos);
        return InteractionResult.CONSUME;
    }

    protected void onExplosionHit(BlockState pState, Level pLevel, BlockPos pPos, Explosion pExplosion, BiConsumer<ItemStack, BlockPos> pDropConsumer) {
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            if (state.getBlock() == ModBlocks.MELON_TRAVELERS_BACKPACK.get()) {
                BackpackAbilities.melonAbility(blockEntity2);
            }
            if (player.isCreative()) {
                ItemStack stack = blockEntity2.toItemStack(this.asItem().getDefaultInstance());
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
            blockEntity2.removeSleepingBag(level, (Direction)state.getValue((Property)FACING));
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            super.onRemove(state, level, pos, newState, isMoving);
            if (blockentity instanceof BackpackBlockEntity) {
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        }
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level.getBlockEntity(pos) == null || !((blockEntity = level.getBlockEntity(pos)) instanceof BackpackBlockEntity)) {
            return 0;
        }
        BackpackBlockEntity backpack = (BackpackBlockEntity)blockEntity;
        float f = 0.0f;
        for (int i = 0; i < backpack.getWrapper().getStorage().getSlots(); ++i) {
            ItemStack itemstack = backpack.getWrapper().getStorage().getStackInSlot(i);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min(backpack.getWrapper().getStorage().getSlotLimit(i), backpack.getWrapper().getStorage().getStackInSlot(i).getMaxStackSize());
        }
        return Mth.lerpDiscrete((float)(f /= (float)backpack.getWrapper().getStorage().getSlots()), (int)0, (int)15);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BackpackBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide || (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get() == false || !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, state.getBlock().asItem().getDefaultInstance()) ? null : BackpackDeathHelper.getTicker(blockEntityType, (BlockEntityType)ModBlockEntityTypes.BACKPACK.get(), BackpackBlockEntity::tick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(state, level, pos, rand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            BackpackAbilities.ABILITIES.animateTick(backpackBlockEntity, state, level, pos, rand);
        }
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BackpackBlockEntity backpackBlockEntity;
        BlockEntity blockEntity;
        if (state.getBlock() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get() && (blockEntity = getter.getBlockEntity(pos)) instanceof BackpackBlockEntity && (backpackBlockEntity = (BackpackBlockEntity)blockEntity).getWrapper().isAbilityEnabled()) {
            return 15;
        }
        return super.getSignal(state, getter, pos, direction);
    }

    public boolean isSignalSource(BlockState state) {
        return state.getBlock() == ModBlocks.REDSTONE_TRAVELERS_BACKPACK.get();
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (!pOldState.is(pState.getBlock()) && pState.getBlock() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.onPlace(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    public void neighborChanged(BlockState state, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (state.getBlock() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
            this.tryAbsorbWater(pLevel, pPos);
        }
        super.neighborChanged(state, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    public void tryAbsorbWater(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> {
                if (backpackBlockEntity.getWrapper().isAbilityEnabled() && (tanksUpgrade.getLeftTank().isEmpty() || tanksUpgrade.getLeftTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity() || tanksUpgrade.getRightTank().isEmpty() || tanksUpgrade.getRightTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()) && this.removeWaterBreadthFirstSearch(level, pos, (TanksUpgrade)tanksUpgrade)) {
                    level.levelEvent(2001, pos, Block.getId((BlockState)Blocks.WATER.defaultBlockState()));
                }
            });
        }
    }

    private boolean removeWaterBreadthFirstSearch(Level level, BlockPos pos, TanksUpgrade tanksUpgrade) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.getA();
            int j = (Integer)tuple.getB();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.relative(direction);
                BlockState blockstate = level.getBlockState(blockpos1);
                FluidState fluidstate = level.getFluidState(blockpos1);
                if (!fluidstate.is(FluidTags.WATER)) continue;
                if (blockstate.getBlock() instanceof BucketPickup && !((BucketPickup)blockstate.getBlock()).pickupBlock(null, (LevelAccessor)level, blockpos1, blockstate).isEmpty()) {
                    ++i;
                    if (tanksUpgrade.getLeftTank().isEmpty() || tanksUpgrade.getLeftTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && tanksUpgrade.getLeftTank().getFluidAmount() < tanksUpgrade.getLeftTank().getCapacity()) {
                        tanksUpgrade.getLeftTank().fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                    } else if (tanksUpgrade.getRightTank().isEmpty() || tanksUpgrade.getRightTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && tanksUpgrade.getRightTank().getFluidAmount() < tanksUpgrade.getRightTank().getCapacity()) {
                        tanksUpgrade.getRightTank().fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.getBlock() instanceof LiquidBlock) {
                    level.setBlock(blockpos1, Blocks.AIR.defaultBlockState(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!(blockstate.is(Blocks.KELP) || blockstate.is(Blocks.KELP_PLANT) || blockstate.is(Blocks.SEAGRASS) || blockstate.is(Blocks.TALL_SEAGRASS))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.hasBlockEntity() ? level.getBlockEntity(blockpos1) : null;
                TravelersBackpackBlock.dropResources((BlockState)blockstate, (LevelAccessor)level, (BlockPos)blockpos1, (BlockEntity)blockentity);
                level.setBlock(blockpos1, Blocks.AIR.defaultBlockState(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.asItem(), 1);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity2 = (BackpackBlockEntity)blockEntity;
            blockEntity2.toItemStack(stack);
        }
        return stack;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        BackpackBlockEntity backpackBlockEntity;
        BlockEntity blockEntity;
        if (state.getBlock() == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get() && (blockEntity = world.getBlockEntity(pos)) instanceof BackpackBlockEntity && (backpackBlockEntity = (BackpackBlockEntity)blockEntity).getWrapper().isAbilityEnabled()) {
            return 5.0f;
        }
        return super.getEnchantPowerBonus(state, world, pos);
    }

    public static void registerDispenserBehaviour() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)holder.get()), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior()));
    }
}

