/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.registry;

import de.mrjulsen.trafficcraft.block.AsphaltBlock;
import de.mrjulsen.trafficcraft.block.AsphaltCurb;
import de.mrjulsen.trafficcraft.block.AsphaltCurbSlope;
import de.mrjulsen.trafficcraft.block.AsphaltSlope;
import de.mrjulsen.trafficcraft.block.ConcreteBarrierBlock;
import de.mrjulsen.trafficcraft.block.DelineatorBlock;
import de.mrjulsen.trafficcraft.block.FluorescentTubeLampBlock;
import de.mrjulsen.trafficcraft.block.GuardrailBlock;
import de.mrjulsen.trafficcraft.block.HouseNumberSignBlock;
import de.mrjulsen.trafficcraft.block.ManholeBlock;
import de.mrjulsen.trafficcraft.block.ManholeCoverBlock;
import de.mrjulsen.trafficcraft.block.PaintBucketBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.ReflectorBlock;
import de.mrjulsen.trafficcraft.block.RoadBarrierFenceBlock;
import de.mrjulsen.trafficcraft.block.RoadSaltBlock;
import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.block.StreetLightBlock;
import de.mrjulsen.trafficcraft.block.StreetSignBlock;
import de.mrjulsen.trafficcraft.block.TownSignBlock;
import de.mrjulsen.trafficcraft.block.TrafficBarrelBlock;
import de.mrjulsen.trafficcraft.block.TrafficBollardBlock;
import de.mrjulsen.trafficcraft.block.TrafficConeBlock;
import de.mrjulsen.trafficcraft.block.TrafficLightBlock;
import de.mrjulsen.trafficcraft.block.TrafficLightControllerBlock;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.TrafficSignBlock;
import de.mrjulsen.trafficcraft.block.TrafficSignPostBlock;
import de.mrjulsen.trafficcraft.block.TrafficSignWorkbenchBlock;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.item.WearableBlockItem;
import de.mrjulsen.trafficcraft.registry.ModCreativeModeTab;
import de.mrjulsen.trafficcraft.registry.ModItems;
import dev.architectury.extensions.injected.InjectedItemPropertiesExtension;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.DeferredSupplier;
import dev.architectury.registry.registries.RegistrySupplier;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"trafficcraft", (ResourceKey)Registries.BLOCK);
    public static List<RegistrySupplier<Block>> COLORED_BLOCKS = new ArrayList<RegistrySupplier<Block>>();
    public static HashMap<String, RegistrySupplier<Block>> ROAD_BLOCKS = new HashMap();
    public static final RegistrySupplier<Block> BITUMEN_ORE = ModBlocks.registerBlock("bitumen_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f).requiresCorrectToolForDrops()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> DEEPSLATE_BITUMEN_ORE = ModBlocks.registerBlock("deepslate_bitumen_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(4.5f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE)), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> BITUMEN_BLOCK = ModBlocks.registerBlock("bitumen_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).strength(1.5f).requiresCorrectToolForDrops()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> SALT = ModBlocks.registerBlock("salt", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(3.0f).sound(SoundType.BASALT).requiresCorrectToolForDrops()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> TRAFFIC_SIGN_WORKBENCH = ModBlocks.registerBlock("traffic_sign_workbench", () -> new TrafficSignWorkbenchBlock(), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> ASPHALT = ModBlocks.registerBlock("asphalt", () -> new AsphaltBlock(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> CONCRETE = ModBlocks.registerBlock("concrete", () -> new AsphaltBlock(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> ASPHALT_SLOPE = ModBlocks.registerBlock("asphalt_slope", () -> new AsphaltSlope(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> CONCRETE_SLOPE = ModBlocks.registerBlock("concrete_slope", () -> new AsphaltSlope(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> ASPHALT_CURB = ModBlocks.registerBlock("asphalt_curb", () -> new AsphaltCurb(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> CONCRETE_CURB = ModBlocks.registerBlock("concrete_curb", () -> new AsphaltCurb(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> ASPHALT_CURB_SLOPE = ModBlocks.registerBlock("asphalt_curb_slope", () -> new AsphaltCurbSlope(RoadType.ASPHALT), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> CONCRETE_CURB_SLOPE = ModBlocks.registerBlock("concrete_curb_slope", () -> new AsphaltCurbSlope(RoadType.CONCRETE), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> ROAD_SALT = ModBlocks.registerBlock("road_salt", () -> new RoadSaltBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> CONCRETE_BARRIER = ModBlocks.registerColoredBlock("concrete_barrier", () -> new ConcreteBarrierBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
    public static final RegistrySupplier<Block> MANHOLE;
    public static final RegistrySupplier<Block> MANHOLE_COVER;
    public static final RegistrySupplier<Block> ROAD_GULLY;
    public static final RegistrySupplier<Block> TRAFFIC_SIGN_POST;
    public static final RegistrySupplier<Block> TRAFFIC_SIGN;
    public static final RegistrySupplier<Block> TOWN_SIGN;
    public static final RegistrySupplier<Block> STREET_SIGN;
    public static final RegistrySupplier<Block> HOUSE_NUMBER_SIGN;
    public static final RegistrySupplier<Block> TRAFFIC_LIGHT;
    public static final RegistrySupplier<Block> TRAFFIC_LIGHT_CONTROLLER;
    public static final RegistrySupplier<Block> TRAFFIC_LIGHT_REQUEST_BUTTON;
    public static final RegistrySupplier<Block> STREET_LAMP;
    public static final RegistrySupplier<Block> DOUBLE_STREET_LAMP;
    public static final RegistrySupplier<Block> SMALL_STREET_LAMP;
    public static final RegistrySupplier<Block> SMALL_DOUBLE_STREET_LAMP;
    public static final RegistrySupplier<Block> STREET_LIGHT;
    public static final RegistrySupplier<Block> FLUORESCENT_TUBE_LAMP;
    public static final RegistrySupplier<Block> WHITE_DELINEATOR;
    public static final RegistrySupplier<Block> YELLOW_DELINEATOR;
    public static final RegistrySupplier<Block> RED_DELINEATOR;
    public static final RegistrySupplier<Block> SMALL_WHITE_DELINEATOR;
    public static final RegistrySupplier<Block> SMALL_YELLOW_DELINEATOR;
    public static final RegistrySupplier<Block> GUARDRAIL;
    public static final RegistrySupplier<Block> PAINT_BUCKET;
    public static final RegistrySupplier<Block> TRAFFIC_CONE;
    public static final RegistrySupplier<Block> TRAFFIC_BOLLARD;
    public static final RegistrySupplier<Block> TRAFFIC_BARREL;
    public static final RegistrySupplier<Block> ROAD_BARRIER_FENCE;
    public static final RegistrySupplier<Block> REFLECTOR;

    private static <T extends Block> RegistrySupplier<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Block> registerColoredBlockWithoutItem(String name, Supplier<Block> block) {
        RegistrySupplier<Block> toReturn = ModBlocks.registerBlockWithoutItem(name, block);
        COLORED_BLOCKS.add(toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Block> registerColoredBlock(String name, Supplier<Block> block, RegistrySupplier<CreativeModeTab> tab, boolean wearable) {
        RegistrySupplier<Block> toReturn = ModBlocks.registerBlock(name, block, tab, wearable);
        COLORED_BLOCKS.add(toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block, RegistrySupplier<CreativeModeTab> tab, boolean wearable) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab, wearable);
        return toReturn;
    }

    private static <T extends Block, I extends BlockItem> RegistrySupplier<T> registerBlock(String name, Supplier<T> block, RegistrySupplier<CreativeModeTab> tab, Class<I> blockItemClass) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn, tab, blockItemClass);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<T> registerBlockWithCustomItemId(String name, String itemId, Supplier<T> block, RegistrySupplier<CreativeModeTab> tab, boolean wearable) {
        RegistrySupplier toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(itemId, toReturn, tab, wearable);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block, RegistrySupplier<CreativeModeTab> tab, boolean wearable) {
        if (wearable) {
            return ModItems.ITEMS.register(name, () -> new WearableBlockItem((Block)block.get(), ((InjectedItemPropertiesExtension)new Item.Properties()).arch$tab((DeferredSupplier)tab)));
        }
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), ((InjectedItemPropertiesExtension)new Item.Properties()).arch$tab((DeferredSupplier)tab)));
    }

    private static <T extends Block, I extends BlockItem> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block, RegistrySupplier<CreativeModeTab> tab, Class<I> blockItemClass) {
        return ModItems.ITEMS.register(name, () -> {
            try {
                return (Item)blockItemClass.getDeclaredConstructor(Block.class, Item.Properties.class).newInstance(block.get(), ((InjectedItemPropertiesExtension)new Item.Properties()).arch$tab((DeferredSupplier)tab));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return new BlockItem((Block)block.get(), ((InjectedItemPropertiesExtension)new Item.Properties()).arch$tab((DeferredSupplier)tab));
            }
        });
    }

    public static void register() {
        BLOCKS.register();
    }

    static {
        for (RoadType s : RoadType.values()) {
            if (s == RoadType.NONE) continue;
            for (int i = 0; i < 323; ++i) {
                String id = s.getRoadType() + "_pattern_" + i;
                RegistrySupplier<Block> block = ModBlocks.registerColoredBlockWithoutItem(id, () -> new PaintedAsphaltBlock(BlockBehaviour.Properties.of(), s));
                ROAD_BLOCKS.put(id, block);
                String id2 = s.getRoadType() + "_slope_pattern_" + i;
                RegistrySupplier<Block> block2 = ModBlocks.registerColoredBlockWithoutItem(id2, () -> new PaintedAsphaltSlope(BlockBehaviour.Properties.of(), s));
                ROAD_BLOCKS.put(id2, block2);
            }
        }
        MANHOLE = ModBlocks.registerBlock("manhole", () -> new ManholeBlock(), ModCreativeModeTab.MOD_TAB, false);
        MANHOLE_COVER = ModBlocks.registerBlock("manhole_cover", () -> new ManholeCoverBlock(), ModCreativeModeTab.MOD_TAB, false);
        ROAD_GULLY = ModBlocks.registerBlock("road_gully", () -> new ManholeCoverBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_SIGN_POST = ModBlocks.registerBlock("traffic_sign_post", () -> new TrafficSignPostBlock(), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_SIGN = ModBlocks.registerBlock("traffic_sign", () -> new TrafficSignBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        TOWN_SIGN = ModBlocks.registerBlock("town_sign", () -> new TownSignBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        STREET_SIGN = ModBlocks.registerColoredBlock("street_sign", () -> new StreetSignBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        HOUSE_NUMBER_SIGN = ModBlocks.registerColoredBlock("house_number_sign", () -> new HouseNumberSignBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_LIGHT = ModBlocks.registerColoredBlock("traffic_light", () -> new TrafficLightBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_LIGHT_CONTROLLER = ModBlocks.registerBlock("traffic_light_controller", () -> new TrafficLightControllerBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        TRAFFIC_LIGHT_REQUEST_BUTTON = ModBlocks.registerBlock("traffic_light_request_button", () -> new TrafficLightRequestButtonBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        STREET_LAMP = ModBlocks.registerBlock("street_lamp", () -> new StreetLampBaseBlock(BlockBehaviour.Properties.of(), StreetLampBaseBlock.LampType.NORMAL), ModCreativeModeTab.MOD_TAB, true);
        DOUBLE_STREET_LAMP = ModBlocks.registerBlock("double_street_lamp", () -> new StreetLampBaseBlock(BlockBehaviour.Properties.of(), StreetLampBaseBlock.LampType.DOUBLE), ModCreativeModeTab.MOD_TAB, true);
        SMALL_STREET_LAMP = ModBlocks.registerBlock("small_street_lamp", () -> new StreetLampBaseBlock(BlockBehaviour.Properties.of(), StreetLampBaseBlock.LampType.SMALL), ModCreativeModeTab.MOD_TAB, true);
        SMALL_DOUBLE_STREET_LAMP = ModBlocks.registerBlock("small_double_street_lamp", () -> new StreetLampBaseBlock(BlockBehaviour.Properties.of(), StreetLampBaseBlock.LampType.SMALL_DOUBLE), ModCreativeModeTab.MOD_TAB, true);
        STREET_LIGHT = ModBlocks.registerBlock("street_light", () -> new StreetLightBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        FLUORESCENT_TUBE_LAMP = ModBlocks.registerBlock("fluorescent_tube_lamp", () -> new FluorescentTubeLampBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        WHITE_DELINEATOR = ModBlocks.registerBlock("white_delineator", () -> new DelineatorBlock(false), ModCreativeModeTab.MOD_TAB, false);
        YELLOW_DELINEATOR = ModBlocks.registerBlock("yellow_delineator", () -> new DelineatorBlock(false), ModCreativeModeTab.MOD_TAB, false);
        RED_DELINEATOR = ModBlocks.registerBlock("red_delineator", () -> new DelineatorBlock(false), ModCreativeModeTab.MOD_TAB, false);
        SMALL_WHITE_DELINEATOR = ModBlocks.registerBlock("small_white_delineator", () -> new DelineatorBlock(true), ModCreativeModeTab.MOD_TAB, false);
        SMALL_YELLOW_DELINEATOR = ModBlocks.registerBlock("small_yellow_delineator", () -> new DelineatorBlock(true), ModCreativeModeTab.MOD_TAB, false);
        GUARDRAIL = ModBlocks.registerColoredBlock("guardrail", () -> new GuardrailBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        PAINT_BUCKET = ModBlocks.registerColoredBlock("paint_bucket", () -> new PaintBucketBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, true);
        TRAFFIC_CONE = ModBlocks.registerColoredBlock("traffic_cone", () -> new TrafficConeBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, true);
        TRAFFIC_BOLLARD = ModBlocks.registerColoredBlock("traffic_bollard", () -> new TrafficBollardBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, true);
        TRAFFIC_BARREL = ModBlocks.registerColoredBlock("traffic_barrel", () -> new TrafficBarrelBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, true);
        ROAD_BARRIER_FENCE = ModBlocks.registerColoredBlock("road_barrier_fence", () -> new RoadBarrierFenceBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
        REFLECTOR = ModBlocks.registerColoredBlock("reflector", () -> new ReflectorBlock(BlockBehaviour.Properties.of()), ModCreativeModeTab.MOD_TAB, false);
    }
}

