/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.mrjulsen.trafficcraft.recipe.IDamageableCraftingItem;
import de.mrjulsen.trafficcraft.registry.ModItems;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class DamageableItemRecipe
extends ShapelessRecipe {
    public DamageableItemRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModItems.DAMAGEABLE_ITEM_RECIPE_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList defaultedList = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < defaultedList.size(); ++i) {
            ItemStack stack = input.getItem(i);
            Item item = stack.getItem();
            if (item instanceof IDamageableCraftingItem) {
                int newDamage = stack.getDamageValue() + 1;
                if (newDamage >= stack.getMaxDamage()) continue;
                stack = stack.copy();
                stack.setDamageValue(newDamage);
                defaultedList.set(i, (Object)stack);
                continue;
            }
            if (!item.hasCraftingRemainingItem()) continue;
            defaultedList.set(i, (Object)new ItemStack((ItemLike)item.getCraftingRemainingItem()));
        }
        return defaultedList;
    }

    public static class Serializer
    implements RecipeSerializer<DamageableItemRecipe> {
        private static final MapCodec<DamageableItemRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapelessRecipe -> shapelessRecipe.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapelessRecipe -> shapelessRecipe.category()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapelessRecipe -> shapelessRecipe.getResultItem(null)), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.getIngredients())).apply((Applicative)instance, DamageableItemRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DamageableItemRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<DamageableItemRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DamageableItemRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static DamageableItemRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String string = buffer.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            int i = buffer.readVarInt();
            NonNullList nonNullList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonNullList.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new DamageableItemRecipe(string, craftingBookCategory, itemStack, (NonNullList<Ingredient>)nonNullList);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, DamageableItemRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
        }
    }
}

