/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.client.screen.menu.TrafficSignWorkbenchMenu;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.network.packets.stc.TrafficSignWorkbenchUpdateClientPacket;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TrafficSignPatternPacket
extends BaseNetworkPacket<TrafficSignPatternPacket> {
    private NamedTrafficSignTextureReference reference;
    private int index;

    public TrafficSignPatternPacket() {
    }

    public TrafficSignPatternPacket(NamedTrafficSignTextureReference reference, int index) {
        this.index = index;
        this.reference = reference;
    }

    public void encode(TrafficSignPatternPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(packet.index);
        NamedTrafficSignTextureReference.toNetwork(buffer, packet.reference);
    }

    public TrafficSignPatternPacket decode(RegistryFriendlyByteBuf buffer) {
        int index = buffer.readInt();
        NamedTrafficSignTextureReference reference = NamedTrafficSignTextureReference.fromNetwork(buffer);
        return new TrafficSignPatternPacket(reference, index);
    }

    public void handle(TrafficSignPatternPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            AbstractContainerMenu patt0$temp = sender.containerMenu;
            if (patt0$temp instanceof TrafficSignWorkbenchMenu) {
                TrafficSignWorkbenchMenu menu = (TrafficSignWorkbenchMenu)patt0$temp;
                ItemStack stack = menu.patternSlot.getItem();
                Item patt1$temp = stack.getItem();
                if (!(patt1$temp instanceof PatternCatalogueItem)) {
                    return;
                }
                PatternCatalogueItem item = (PatternCatalogueItem)patt1$temp;
                if (packet.index >= 0) {
                    item.replacePattern(stack, packet.reference, packet.index);
                } else {
                    item.setPattern(stack, packet.reference);
                }
                menu.patternSlot.set(stack);
                menu.patternSlot.setChanged();
                menu.broadcastChanges();
                DLUtils.giveAdvancement((ServerPlayer)sender, (String)"trafficcraft", (String)"create_traffic_sign_pattern", (String)"requirement");
                DLNetworkManager.sendToPlayer((ServerPlayer)sender, (BaseNetworkPacket)new TrafficSignWorkbenchUpdateClientPacket());
            }
        });
    }
}

