/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightSchedulePacket
extends BaseNetworkPacket<TrafficLightSchedulePacket> {
    private BlockPos pos;
    private List<TrafficLightSchedule> schedules = new ArrayList<TrafficLightSchedule>();

    public TrafficLightSchedulePacket() {
    }

    public TrafficLightSchedulePacket(BlockPos pos, List<TrafficLightSchedule> schedules) {
        this.pos = pos;
        this.schedules = schedules;
    }

    public void encode(TrafficLightSchedulePacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(packet.pos);
        buffer.writeInt(packet.schedules.size());
        for (TrafficLightSchedule schedule : packet.schedules) {
            schedule.toBytes(buffer);
        }
    }

    public TrafficLightSchedulePacket decode(RegistryFriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        int size = buffer.readInt();
        ArrayList<TrafficLightSchedule> schedules = new ArrayList<TrafficLightSchedule>();
        for (int i = 0; i < size; ++i) {
            schedules.add(TrafficLightSchedule.fromBytes(buffer));
        }
        return new TrafficLightSchedulePacket(pos, schedules);
    }

    public void handle(TrafficLightSchedulePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Level level;
            ServerPlayer player = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null && (level = player.level()).isLoaded(packet.pos)) {
                BlockEntity patt0$temp = level.getBlockEntity(packet.pos);
                if (patt0$temp instanceof TrafficLightControllerBlockEntity) {
                    TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)patt0$temp;
                    blockEntity.setSchedules(packet.schedules);
                } else {
                    BlockEntity patt1$temp = level.getBlockEntity(packet.pos);
                    if (patt1$temp instanceof TrafficLightBlockEntity) {
                        TrafficLightBlockEntity blockEntity = (TrafficLightBlockEntity)patt1$temp;
                        blockEntity.setSchedule(packet.schedules.get(0));
                    }
                }
            }
        });
    }
}

