/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.trafficcraft.block.TownSignBlock;
import de.mrjulsen.trafficcraft.block.data.TownSignVariant;
import de.mrjulsen.trafficcraft.block.entity.TownSignBlockEntity;
import dev.architectury.networking.NetworkManager;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TownSignPacket
extends BaseNetworkPacket<TownSignPacket> {
    private String[] messages;
    private TownSignVariant variant;
    private BlockPos pos;
    private TownSignBlock.ETownSignSide side;

    public TownSignPacket() {
    }

    public TownSignPacket(BlockPos pos, String[] messages, TownSignVariant variant, TownSignBlock.ETownSignSide side) {
        this.pos = pos;
        this.variant = variant;
        this.messages = messages;
        this.side = side;
    }

    public void encode(TownSignPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(packet.pos);
        buffer.writeInt(packet.variant.getIndex());
        buffer.writeInt(packet.side.getIndex());
        buffer.writeInt(packet.messages.length);
        for (int i = 0; i < packet.messages.length; ++i) {
            String message = packet.messages[i];
            int messageLength = packet.messages[i].getBytes(StandardCharsets.UTF_8).length;
            buffer.writeInt(messageLength);
            buffer.writeUtf(message, messageLength);
        }
    }

    public TownSignPacket decode(RegistryFriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        TownSignVariant variant = TownSignVariant.getVariantByIndex(buffer.readInt());
        TownSignBlock.ETownSignSide side = TownSignBlock.ETownSignSide.getSideByIndex(buffer.readInt());
        int messagesCount = buffer.readInt();
        String[] messages = new String[messagesCount];
        for (int i = 0; i < messagesCount; ++i) {
            int messageLength = buffer.readInt();
            messages[i] = buffer.readUtf(messageLength);
        }
        TownSignPacket instance = new TownSignPacket(pos, messages, variant, side);
        return instance;
    }

    public void handle(TownSignPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            BlockEntity patt0$temp;
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (sender.level().getBlockState(packet.pos).getBlock() instanceof TownSignBlock && (patt0$temp = sender.level().getBlockEntity(packet.pos)) instanceof TownSignBlockEntity) {
                TownSignBlockEntity blockEntity = (TownSignBlockEntity)patt0$temp;
                switch (packet.side) {
                    case BACK: {
                        blockEntity.setBackTexts(packet.messages);
                        break;
                    }
                    default: {
                        blockEntity.setTexts(packet.messages);
                    }
                }
                BlockState state = sender.level().getBlockState(packet.pos);
                sender.level().setBlockAndUpdate(packet.pos, (BlockState)state.setValue(TownSignBlock.VARIANT, (Comparable)((Object)packet.variant)));
            }
        });
    }
}

