/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.components.StreetLampComponent;
import de.mrjulsen.trafficcraft.item.StreetLampConfigCardItem;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StreetLampConfigPacket
extends BaseNetworkPacket<StreetLampConfigPacket> {
    private int turnOnTime;
    private int turnOffTime;
    private TimeUtils.TimeFormat timeFormat;

    public StreetLampConfigPacket() {
    }

    public StreetLampConfigPacket(int turnOnTime, int turnOffTime, TimeUtils.TimeFormat timeFormat) {
        this.turnOnTime = turnOnTime;
        this.turnOffTime = turnOffTime;
        this.timeFormat = timeFormat;
    }

    public void encode(StreetLampConfigPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(packet.turnOnTime);
        buffer.writeInt(packet.turnOffTime);
        buffer.writeInt((int)packet.timeFormat.getIndex());
    }

    public StreetLampConfigPacket decode(RegistryFriendlyByteBuf buffer) {
        int turnOnTime = buffer.readInt();
        int turnOffTime = buffer.readInt();
        int timeFormat = buffer.readInt();
        return new StreetLampConfigPacket(turnOnTime, turnOffTime, TimeUtils.TimeFormat.getFormatByIndex((byte)((byte)timeFormat)));
    }

    public void handle(StreetLampConfigPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            ItemStack stack = sender.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof StreetLampConfigCardItem) {
                StreetLampConfigCardItem item = (StreetLampConfigCardItem)patt0$temp;
                item.setComponent(stack, new StreetLampComponent(packet.turnOnTime, packet.turnOffTime, packet.timeFormat));
            } else {
                stack = sender.getOffhandItem();
                Item patt1$temp = stack.getItem();
                if (patt1$temp instanceof StreetLampConfigCardItem) {
                    StreetLampConfigCardItem item = (StreetLampConfigCardItem)patt1$temp;
                    item.setComponent(stack, new StreetLampComponent(packet.turnOnTime, packet.turnOffTime, packet.timeFormat));
                }
            }
            sender.getInventory().setChanged();
        });
    }
}

