/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.components.RoadConstructionToolComponent;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RoadBuilderDataPacket
extends BaseNetworkPacket<RoadBuilderDataPacket> {
    private boolean replaceBlocks;
    private byte roadWidth;
    private RoadType roadType;

    public RoadBuilderDataPacket() {
    }

    public RoadBuilderDataPacket(boolean replaceBlocks, byte roadWidth, RoadType roadType) {
        this.replaceBlocks = replaceBlocks;
        this.roadWidth = roadWidth;
        this.roadType = roadType;
    }

    public void encode(RoadBuilderDataPacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.replaceBlocks);
        buffer.writeByte((int)packet.roadWidth);
        buffer.writeEnum((Enum)packet.roadType);
    }

    public RoadBuilderDataPacket decode(RegistryFriendlyByteBuf buffer) {
        boolean replaceBlocks = buffer.readBoolean();
        byte roadWidth = buffer.readByte();
        RoadType roadType = (RoadType)buffer.readEnum(RoadType.class);
        return new RoadBuilderDataPacket(replaceBlocks, roadWidth, roadType);
    }

    public void handle(RoadBuilderDataPacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            ItemStack stack = sender.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof RoadConstructionTool) {
                RoadConstructionTool item = (RoadConstructionTool)patt0$temp;
                comp = (RoadConstructionToolComponent)item.getComponent(stack);
                item.setComponent(stack, new RoadConstructionToolComponent(comp.start(), comp.end(), packet.roadType, packet.roadWidth, packet.replaceBlocks));
            } else {
                stack = sender.getOffhandItem();
                Item patt1$temp = stack.getItem();
                if (patt1$temp instanceof RoadConstructionTool) {
                    RoadConstructionTool item = (RoadConstructionTool)patt1$temp;
                    comp = (RoadConstructionToolComponent)item.getComponent(stack);
                    item.setComponent(stack, new RoadConstructionToolComponent(comp.start(), comp.end(), packet.roadType, packet.roadWidth, packet.replaceBlocks));
                }
            }
            sender.getInventory().setChanged();
        });
    }
}

