/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.network.packets.cts;

import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.trafficcraft.components.TrafficLightLinkerComponent;
import de.mrjulsen.trafficcraft.item.TrafficLightLinkerItem;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class LinkerModePacket
extends BaseNetworkPacket<LinkerModePacket> {
    private TrafficLightLinkerItem.LinkerMode mode;

    public LinkerModePacket() {
    }

    public LinkerModePacket(TrafficLightLinkerItem.LinkerMode mode) {
        this.mode = mode;
    }

    public void encode(LinkerModePacket packet, RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)packet.mode);
    }

    public LinkerModePacket decode(RegistryFriendlyByteBuf buffer) {
        TrafficLightLinkerItem.LinkerMode mode = (TrafficLightLinkerItem.LinkerMode)buffer.readEnum(TrafficLightLinkerItem.LinkerMode.class);
        return new LinkerModePacket(mode);
    }

    public void handle(LinkerModePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            ServerPlayer sender = (ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            ItemStack stack = sender.getMainHandItem();
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof TrafficLightLinkerItem) {
                TrafficLightLinkerItem item = (TrafficLightLinkerItem)patt0$temp;
                comp = (TrafficLightLinkerComponent)item.getComponent(stack);
                item.setComponent(stack, new TrafficLightLinkerComponent(comp.location(), this.mode, comp.targetBlockName()));
            } else {
                stack = sender.getOffhandItem();
                Item patt1$temp = stack.getItem();
                if (patt1$temp instanceof TrafficLightLinkerItem) {
                    TrafficLightLinkerItem item = (TrafficLightLinkerItem)patt1$temp;
                    comp = (TrafficLightLinkerComponent)item.getComponent(stack);
                    item.setComponent(stack, new TrafficLightLinkerComponent(comp.location(), this.mode, comp.targetBlockName()));
                }
            }
            sender.getInventory().setChanged();
        });
    }
}

