/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.item;

import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightRequestButtonBlockEntity;
import de.mrjulsen.trafficcraft.components.TrafficLightLinkerComponent;
import de.mrjulsen.trafficcraft.item.ILinkerItem;
import de.mrjulsen.trafficcraft.item.IScrollEventItem;
import de.mrjulsen.trafficcraft.item.IUseDataComponent;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import de.mrjulsen.trafficcraft.registry.ModDataComponents;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightLinkerItem
extends Item
implements ILinkerItem,
IScrollEventItem,
IUseDataComponent<TrafficLightLinkerComponent> {
    public static final String NBT_LINK_TARGET = "LinkTargetLocation";
    public static final String NBT_MODE = "Mode";
    public static final String NBT_BLOCK = "Block";
    private static final Component textNoLink = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.tooltip.nolink").withStyle(ChatFormatting.GRAY);
    private static final Component textNotLoaded = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.use.target_not_loaded").withStyle(ChatFormatting.RED);
    private static final Component textClear = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.use.clear");
    private static final Component textTooltipInstruction = TextUtils.translate((String)"item.trafficcraft.traffic_light_linker.tooltip_instruction").withStyle(ChatFormatting.ITALIC);
    private static final String keySet = "item.trafficcraft.traffic_light_linker.use.set";
    private static final String keyWrongDim = "item.trafficcraft.traffic_light_linker.use.wrong_dimension";
    private static final String keySetLink = "item.trafficcraft.traffic_light_linker.use.link";
    private static final String keyRemoveLink = "item.trafficcraft.traffic_light_linker.use.unlink";
    private static final String keyTooltipLocation = "item.trafficcraft.traffic_light_linker.tooltip_location";
    private static final String keyTooltipBlock = "item.trafficcraft.traffic_light_linker.tooltip_block";
    private static final String keyTooltipMode = "item.trafficcraft.traffic_light_linker.tooltip_mode";

    public TrafficLightLinkerItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos clickedPos = pContext.getClickedPos();
        Player player = pContext.getPlayer();
        ItemStack stack = pContext.getItemInHand();
        if (!player.isShiftKeyDown()) {
            Block clickedBlock = pContext.getLevel().getBlockState(clickedPos).getBlock();
            if (!this.hasComponent(stack) && this.isSourceBlockAccepted(clickedBlock)) {
                if (!level.isClientSide) {
                    TrafficLightLinkerComponent comp = (TrafficLightLinkerComponent)this.getComponent(stack);
                    this.setComponent(stack, new TrafficLightLinkerComponent(Optional.of(new Location(clickedPos.getX(), clickedPos.getY(), clickedPos.getZ(), level.dimension().location().toString())), comp.mode(), Optional.of(ModBlocks.BLOCKS.getRegistrar().getId((Object)clickedBlock).toString())));
                    player.displayClientMessage((Component)TextUtils.translate((String)keySet, (Object[])new Object[]{clickedPos.toShortString(), level.dimension().location().toString()}).withStyle(ChatFormatting.AQUA), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isTargetBlockAccepted(clickedBlock)) {
                BlockEntity blockEntity;
                if (!this.hasComponent(stack)) {
                    return InteractionResult.FAIL;
                }
                TrafficLightLinkerComponent comp = (TrafficLightLinkerComponent)this.getComponent(stack);
                Optional<Location> linkLoc = comp.location();
                LinkerMode mode = comp.mode();
                if (!linkLoc.isPresent()) {
                    return InteractionResult.FAIL;
                }
                if (!pContext.getLevel().dimension().location().toString().equals(linkLoc.get().dimension)) {
                    player.displayClientMessage((Component)TextUtils.translate((String)keyWrongDim).withStyle(ChatFormatting.RED), true);
                }
                if (clickedBlock instanceof TrafficLightRequestButtonBlock && (blockEntity = pContext.getLevel().getBlockEntity(clickedPos)) instanceof TrafficLightRequestButtonBlockEntity) {
                    TrafficLightRequestButtonBlockEntity blockEntity2 = (TrafficLightRequestButtonBlockEntity)blockEntity;
                    switch (mode.ordinal()) {
                        case 1: {
                            blockEntity2.clearLink();
                            player.displayClientMessage((Component)TextUtils.translate((String)keyRemoveLink, (Object[])new Object[]{linkLoc.get().getLocationBlockPos().toShortString(), level.dimension().location().toString()}).withStyle(ChatFormatting.RED), true);
                            break;
                        }
                        default: {
                            blockEntity2.linkTo(linkLoc.get());
                            player.displayClientMessage((Component)TextUtils.translate((String)keySetLink, (Object[])new Object[]{linkLoc.get().getLocationBlockPos().toShortString(), level.dimension().location().toString()}).withStyle(ChatFormatting.GREEN), true);
                            break;
                        }
                    }
                } else if (pContext.getLevel().isLoaded(linkLoc.get().getLocationBlockPos()) && this.isSourceBlockAccepted(pContext.getLevel().getBlockState(linkLoc.get().getLocationBlockPos()).getBlock())) {
                    BlockEntity blockEntity3 = pContext.getLevel().getBlockEntity(linkLoc.get().getLocationBlockPos());
                    if (blockEntity3 instanceof TrafficLightControllerBlockEntity) {
                        TrafficLightControllerBlockEntity blockEntity4 = (TrafficLightControllerBlockEntity)blockEntity3;
                        BlockPos pos = pContext.getClickedPos();
                        String dim = pContext.getLevel().dimension().location().toString();
                        switch (mode.ordinal()) {
                            case 1: {
                                blockEntity4.removeTrafficLightLocation(new Location(pos.getX(), pos.getY(), pos.getZ(), dim));
                                player.displayClientMessage((Component)TextUtils.translate((String)keyRemoveLink, (Object[])new Object[]{linkLoc.get().getLocationBlockPos().toShortString(), level.dimension().location().toString()}).withStyle(ChatFormatting.RED), true);
                                break;
                            }
                            default: {
                                blockEntity4.addTrafficLightLocation(new Location(pos.getX(), pos.getY(), pos.getZ(), dim));
                                player.displayClientMessage((Component)TextUtils.translate((String)keySetLink, (Object[])new Object[]{linkLoc.get().getLocationBlockPos().toShortString(), level.dimension().location().toString()}).withStyle(ChatFormatting.GREEN), true);
                            }
                        }
                    }
                } else {
                    player.displayClientMessage(textNotLoaded, true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(pContext);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pUsedHand);
        if (pPlayer.isShiftKeyDown()) {
            Level level = pPlayer.level();
            if (!level.isClientSide) {
                itemstack.remove((DataComponentType)ModDataComponents.TRAFFIC_LIGHT_LINKER_COMPONENT.get());
                pPlayer.displayClientMessage(textClear, true);
            }
            return InteractionResultHolder.success((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (this.hasComponent(stack)) {
            TrafficLightLinkerComponent comp = (TrafficLightLinkerComponent)this.getComponent(stack);
            Optional<Location> loc = comp.location();
            LinkerMode mode = comp.mode();
            Optional<String> block = comp.targetBlockName();
            if (loc.isPresent()) {
                tooltipComponents.add((Component)TextUtils.translate((String)keyTooltipLocation, (Object[])new Object[]{Integer.toString((int)loc.get().x), Integer.toString((int)loc.get().y), Integer.toString((int)loc.get().z), loc.get().dimension}));
            }
            if (block.isPresent()) {
                try {
                    ResourceLocation location = ResourceLocation.parse((String)block.get());
                    tooltipComponents.add((Component)TextUtils.translate((String)keyTooltipBlock, (Object[])new Object[]{((Block)ModBlocks.BLOCKS.getRegistrar().get(location)).getName().getString()}));
                }
                catch (Exception e) {
                    tooltipComponents.add((Component)TextUtils.translate((String)keyTooltipBlock, (Object[])new Object[]{TextUtils.text((String)"ERROR").withStyle(ChatFormatting.RED)}));
                }
            }
            tooltipComponents.add((Component)TextUtils.translate((String)keyTooltipMode, (Object[])new Object[]{TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft")), TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft"))}));
            tooltipComponents.add(textTooltipInstruction);
        } else {
            tooltipComponents.add(textNoLink);
        }
    }

    public boolean isFoil(ItemStack pStack) {
        return this.hasComponent(pStack) && ((TrafficLightLinkerComponent)this.getComponent(pStack)).location().isPresent() || super.isFoil(pStack);
    }

    @Override
    public boolean isTargetBlockAccepted(Block block) {
        return block.equals(ModBlocks.TRAFFIC_LIGHT.get()) || block.equals(ModBlocks.TRAFFIC_LIGHT_REQUEST_BUTTON.get());
    }

    @Override
    public boolean isSourceBlockAccepted(Block block) {
        return block.equals(ModBlocks.TRAFFIC_LIGHT_CONTROLLER.get()) || block.equals(ModBlocks.TRAFFIC_LIGHT.get());
    }

    @Override
    public boolean mouseScroll(Player player, ItemStack itemStack, double scrollDelta) {
        if (player.isCrouching()) {
            TrafficLightLinkerComponent comp = (TrafficLightLinkerComponent)this.getComponent(itemStack);
            LinkerMode mode = LinkerMode.LINK;
            if (scrollDelta > 0.0) {
                mode = (LinkerMode)comp.mode().next();
            } else if (scrollDelta < 0.0) {
                mode = (LinkerMode)comp.mode().previous();
            }
            this.setComponent(itemStack, new TrafficLightLinkerComponent(comp.location(), mode, comp.targetBlockName()));
            player.displayClientMessage((Component)TextUtils.translate((String)keyTooltipMode, (Object[])new Object[]{TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft")), TextUtils.translate((String)mode.getValueTranslationKey("trafficcraft"))}), true);
            return true;
        }
        return false;
    }

    @Override
    public DataComponentType<TrafficLightLinkerComponent> getComponentType() {
        return (DataComponentType)ModDataComponents.TRAFFIC_LIGHT_LINKER_COMPONENT.get();
    }

    @Override
    public TrafficLightLinkerComponent emptyComponent() {
        return TrafficLightLinkerComponent.empty();
    }

    public static enum LinkerMode implements StringRepresentable,
    ITranslatableEnum,
    IIterableEnum<LinkerMode>
    {
        LINK(0, "link"),
        UNLINK(1, "unlink");

        private int index;
        private String name;

        private LinkerMode(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static LinkerMode getByIndex(int index) {
            return Arrays.stream(LinkerMode.values()).filter(x -> x.getIndex() == index).findFirst().orElse(LINK);
        }

        public LinkerMode[] getValues() {
            return LinkerMode.values();
        }

        public String getEnumName() {
            return "linkermode";
        }

        public String getEnumValueName() {
            return this.getName();
        }

        public String getSerializedName() {
            return this.getName();
        }
    }
}

