/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.init;

import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.Wikipedia;
import de.mrjulsen.trafficcraft.CrossPlatform;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.client.TintedTextures;
import de.mrjulsen.trafficcraft.client.ber.TownSignBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.ber.TrafficLightBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.ber.TrafficSignBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.ber.WritableSignBlockEntityRenderer;
import de.mrjulsen.trafficcraft.client.screen.TrafficSignWorkbenchGui;
import de.mrjulsen.trafficcraft.client.screen.menu.ModMenuTypes;
import de.mrjulsen.trafficcraft.client.tooltip.ClientTrafficSignTooltipStack;
import de.mrjulsen.trafficcraft.client.tooltip.TrafficSignTooltip;
import de.mrjulsen.trafficcraft.components.BrushComponent;
import de.mrjulsen.trafficcraft.components.TrafficLightLinkerComponent;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.item.IScrollEventItem;
import de.mrjulsen.trafficcraft.item.RoadConstructionTool;
import de.mrjulsen.trafficcraft.item.TrafficLightLinkerItem;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import de.mrjulsen.trafficcraft.registry.ModItems;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ClientInit {
    private static final int CHECKERBOARD_COLOR_A = -1447447;
    private static final int CHECKERBOARD_COLOR_B = -2500135;
    private static final Map<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>> tooltipComponentFactories = new ConcurrentHashMap<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>>();
    public static final DynamicTexture[] SHAPE_TEXTURES = new DynamicTexture[TrafficSignShape.values().length];

    public static int[][] textureToIntArray(DynamicTexture tex, boolean flipRgb) {
        int[][] a = new int[tex.getPixels().getWidth()][];
        for (int x = 0; x < tex.getPixels().getWidth(); ++x) {
            a[x] = new int[tex.getPixels().getHeight()];
            for (int y = 0; y < tex.getPixels().getHeight(); ++y) {
                a[x][y] = flipRgb ? ColorUtils.swapRedBlue((int)tex.getPixels().getPixelRGBA(x, y)) : tex.getPixels().getPixelRGBA(x, y);
            }
        }
        return a;
    }

    public static void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(mc -> {
            Wikipedia.addArticle((String[])new String[]{"Q8004", "Q2354774"});
            ItemModelGenerator.LAYERS.add("layer5");
            ItemModelGenerator.LAYERS.add("layer6");
            ItemModelGenerator.LAYERS.add("layer7");
            ItemModelGenerator.LAYERS.add("layer8");
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)ModBlocks.PAINT_BUCKET.get(), (Block)ModBlocks.MANHOLE.get(), (Block)ModBlocks.MANHOLE_COVER.get(), (Block)ModBlocks.TRAFFIC_SIGN_WORKBENCH.get()});
            RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)ModBlocks.ROAD_SALT.get()});
            RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])((Block[])ModBlocks.COLORED_BLOCKS.stream().filter(x -> x.getId().toString().contains("pattern")).map(Supplier::get).toArray(Block[]::new)));
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.TOWN_SIGN_BLOCK_ENTITY.get()), TownSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.STREET_SIGN_BLOCK_ENTITY.get()), WritableSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.HOUSE_NUMBER_SIGN_BLOCK_ENTITY.get()), WritableSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.TRAFFIC_SIGN_BLOCK_ENTITY.get()), TrafficSignBlockEntityRenderer::new);
            BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_BLOCK_ENTITY.get()), TrafficLightBlockEntityRenderer::new);
            if (Platform.isFabric()) {
                ClientInit.registerTooltipComponentFactory(TrafficSignTooltip.class, tooltip -> new ClientTrafficSignTooltipStack((TrafficSignTooltip)tooltip));
            }
            CrossPlatform.registerScreenFactory((MenuType)ModMenuTypes.TRAFFIC_SIGN_WORKBENCH_MENU.get(), TrafficSignWorkbenchGui::new);
            ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.PAINT_BRUSH.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)"paint"), (itemStack, world, entity, id) -> {
                Item patt0$temp = itemStack.getItem();
                if (!(patt0$temp instanceof BrushItem)) {
                    return 0.0f;
                }
                BrushItem item = (BrushItem)patt0$temp;
                if (!item.hasComponent(itemStack)) {
                    return 0.0f;
                }
                return ((BrushComponent)item.getComponent(itemStack)).paintAmount();
            });
            ItemPropertiesRegistry.register((ItemLike)((ItemLike)ModItems.TRAFFIC_LIGHT_LINKER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trafficcraft", (String)"mode"), (itemStack, world, entity, id) -> {
                Item patt0$temp = itemStack.getItem();
                if (!(patt0$temp instanceof TrafficLightLinkerItem)) {
                    return 0.0f;
                }
                TrafficLightLinkerItem item = (TrafficLightLinkerItem)patt0$temp;
                if (!item.hasComponent(itemStack)) {
                    return 0.0f;
                }
                return ((TrafficLightLinkerComponent)item.getComponent(itemStack)).mode().getIndex();
            });
        });
        ClientLifecycleEvent.CLIENT_STARTED.register(mc -> {
            ColorHandlerRegistry.registerBlockColors((BlockColor)new TintedTextures.TintedBlock(), (Supplier[])((Supplier[])ModBlocks.COLORED_BLOCKS.toArray(RegistrySupplier[]::new)));
            ColorHandlerRegistry.registerItemColors((ItemColor)new TintedTextures.TintedItem(), (Supplier[])new Supplier[]{ModBlocks.GUARDRAIL, ModItems.PAINT_BRUSH, ModBlocks.TRAFFIC_CONE, ModBlocks.TRAFFIC_BOLLARD, ModBlocks.TRAFFIC_BARREL, ModBlocks.ROAD_BARRIER_FENCE, ModBlocks.CONCRETE_BARRIER, ModItems.COLOR_PALETTE});
            DynamicTexture[] textures = (DynamicTexture[])Arrays.stream(TrafficSignShape.values()).map(v -> {
                NativeImage image = new NativeImage(NativeImage.Format.RGBA, 32, 32, false);
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        if (v.isPixelValid(x, y)) {
                            image.setPixelRGBA(x, y, x % 2 == 0 ? (y % 2 == 0 ? -1447447 : -2500135) : (y % 2 == 0 ? -2500135 : -1447447));
                            continue;
                        }
                        image.setPixelRGBA(x, y, 0);
                    }
                }
                return new DynamicTexture(image);
            }).toArray(DynamicTexture[]::new);
            for (int i = 0; i < textures.length; ++i) {
                ClientInit.SHAPE_TEXTURES[i] = textures[i];
            }
        });
        ClientTickEvent.CLIENT_LEVEL_POST.register(level -> RoadConstructionTool.clientTick());
        ClientRawInputEvent.MOUSE_SCROLLED.register((mc, deltaX, deltaY) -> {
            IScrollEventItem item;
            Item patt0$temp;
            ItemStack stack;
            LocalPlayer player = mc.player;
            if (player == null || deltaY == 0.0) {
                return EventResult.pass();
            }
            ItemStack itemStack = stack = player.getMainHandItem() == null ? player.getOffhandItem() : player.getMainHandItem();
            if (stack != null && (patt0$temp = stack.getItem()) instanceof IScrollEventItem && (item = (IScrollEventItem)patt0$temp).mouseScroll((Player)player, stack, deltaY)) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ClientGuiEvent.DEBUG_TEXT_LEFT.register(list -> list.add(String.format("TC | T: %s", TrafficSignClientTexture.debug_cachedTexturesCount())));
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            TrafficCraft.LOGGER.info("Cleaning up traffic sign texture cache...");
            int count = TrafficSignClientTexture.closeAll();
            TrafficCraft.LOGGER.info("All " + count + " loaded custom traffic sign textures have been closed.");
        });
    }
}

