/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class NamedTrafficSignTextureReference {
    public static final MapCodec<NamedTrafficSignTextureReference> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("texture_id").forGetter(NamedTrafficSignTextureReference::getTextureId), (App)Codec.STRING.fieldOf("name").forGetter(NamedTrafficSignTextureReference::getName)).apply((Applicative)instance, NamedTrafficSignTextureReference::new));
    private final String textureId;
    private final String name;

    private NamedTrafficSignTextureReference(String textureId, String name) {
        this.textureId = textureId;
        this.name = name;
    }

    public String getTextureId() {
        return this.textureId;
    }

    public String getName() {
        return this.name;
    }

    public static NamedTrafficSignTextureReference fromNetwork(RegistryFriendlyByteBuf buffer) {
        String textureId = buffer.readUtf();
        String name = buffer.readUtf();
        return new NamedTrafficSignTextureReference(textureId, name);
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, NamedTrafficSignTextureReference ref) {
        buffer.writeUtf(ref.getTextureId());
        buffer.writeUtf(ref.getName());
    }

    public static NamedTrafficSignTextureReference of(TrafficSignTextureData data, String name) {
        return new NamedTrafficSignTextureReference(data.getHash().toString(), name);
    }

    public static NamedTrafficSignTextureReference ofBuildIn(String name, BuildInTrafficSignCodec codec) {
        return new NamedTrafficSignTextureReference(codec.encode(), name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamedTrafficSignTextureReference) {
            NamedTrafficSignTextureReference o = (NamedTrafficSignTextureReference)obj;
            return this.getTextureId().equals(o.getTextureId()) && this.getName().equals(o.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getTextureId(), this.getName());
    }

    public String toString() {
        return this.getName();
    }

    public record BuildInTrafficSignCodec(TrafficSignShape shape, int id, short width, short height) {
        public static final String PREFIX = "builtIn";

        public String encode() {
            return String.format("%s_%s_%s@%sx%s", PREFIX, this.shape().getIndex(), this.id(), this.width(), this.height());
        }

        public static BuildInTrafficSignCodec decode(String code) {
            try {
                String[] parts = code.split("@");
                String[] locationData = parts[0].split("_");
                String[] sizeData = parts.length > 1 ? parts[1].split("x") : new String[]{};
                int shapeIndex = Integer.parseInt(locationData[1]);
                int id = Integer.parseInt(locationData[2]);
                short width = sizeData.length > 0 ? (short)Short.parseShort(sizeData[0]) : (short)32;
                short height = sizeData.length > 0 ? (short)Short.parseShort(sizeData[1]) : (short)32;
                return new BuildInTrafficSignCodec(TrafficSignShape.getShapeByIndex(shapeIndex), id, width, height);
            }
            catch (Exception e) {
                TrafficCraft.LOGGER.warn("Unable to decode traffic sign texture location.", (Throwable)e);
                return BuildInTrafficSignCodec.empty();
            }
        }

        public static BuildInTrafficSignCodec empty() {
            return new BuildInTrafficSignCodec(TrafficSignShape.CIRCLE, 0, 32, 32);
        }

        @Override
        public final String toString() {
            return this.encode();
        }
    }
}

