/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen.menu;

import de.mrjulsen.trafficcraft.TrafficCraft;
import de.mrjulsen.trafficcraft.client.screen.menu.ModMenuTypes;
import de.mrjulsen.trafficcraft.item.ColorPaletteItem;
import de.mrjulsen.trafficcraft.item.PatternCatalogueItem;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class TrafficSignWorkbenchMenu
extends AbstractContainerMenu {
    public final ContainerLevelAccess access;
    private static final int INVENTORY_SIZE = 2;
    public final Slot colorSlot;
    public final Slot patternSlot;
    private final Container container = new SimpleContainer(2);
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public TrafficSignWorkbenchMenu(int pContainerId, Inventory inv) {
        this(pContainerId, inv, ContainerLevelAccess.NULL);
    }

    public TrafficSignWorkbenchMenu(int pContainerId, Inventory inv, ContainerLevelAccess access) {
        super((MenuType)ModMenuTypes.TRAFFIC_SIGN_WORKBENCH_MENU.get(), pContainerId);
        TrafficSignWorkbenchMenu.checkContainerSize((Container)inv, (int)2);
        this.access = access;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.patternSlot = this.addSlot(new Slot(this, this.container, 0, 10, 15){

            public boolean mayPlace(ItemStack pStack) {
                return pStack.getItem() instanceof PatternCatalogueItem;
            }
        });
        this.colorSlot = this.addSlot(new Slot(this, this.container, 1, 204, 15){

            public boolean mayPlace(ItemStack pStack) {
                return pStack.getItem() instanceof ColorPaletteItem;
            }
        });
    }

    public boolean stillValid(Player pPlayer) {
        return TrafficSignWorkbenchMenu.stillValid((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.TRAFFIC_SIGN_WORKBENCH.get()));
    }

    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.access.execute((p_39871_, p_39872_) -> this.clearContainer(pPlayer, this.container));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 6 + l * 18, 198 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 3; ++l) {
                this.addSlot(new Slot((Container)playerInventory, i + l * 3, 172 + i * 18, 198 + l * 18));
            }
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 38, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 38) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            TrafficCraft.LOGGER.warn("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }
}

