/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Clipboard;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.Constants;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.client.ModGuiUtils;
import de.mrjulsen.trafficcraft.client.screen.TrafficLightScheduleEditor;
import de.mrjulsen.trafficcraft.data.TrafficLightSchedule;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficLightControllerPacket;
import de.mrjulsen.trafficcraft.network.packets.cts.TrafficLightSchedulePacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrafficLightControllerScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.trafficlightcontroller.title");
    private static final int GUI_WIDTH = 240;
    private int guiTop = 50;
    private static final int HEIGHT = 150;
    private BlockPos blockPos;
    private Level level;
    private boolean status;
    private DLIconButton pasteButton;
    protected DLCycleButton<Boolean> statusButton;
    protected DLButton editScheduleButton;
    private Component textStatus = TextUtils.translate((String)"gui.trafficcraft.trafficlightcontroller.status");
    private Component textEditSchedule = TextUtils.translate((String)"gui.trafficcraft.trafficlightcontroller.edit_schedule");

    public TrafficLightControllerScreen(BlockPos pos, Level level) {
        super(title);
        this.level = level;
        this.blockPos = pos;
        BlockEntity blockEntity = this.level.getBlockEntity(this.blockPos);
        if (blockEntity instanceof TrafficLightControllerBlockEntity) {
            TrafficLightControllerBlockEntity blockEntity2 = (TrafficLightControllerBlockEntity)blockEntity;
            this.status = blockEntity2.isRunning();
        }
    }

    public TrafficLightControllerBlockEntity getBlockEntity() {
        BlockEntity be = this.level.getBlockEntity(this.blockPos);
        return be instanceof TrafficLightControllerBlockEntity ? (TrafficLightControllerBlockEntity)be : null;
    }

    public void init() {
        super.init();
        this.guiTop = this.height / 2 - 75;
        this.addButton(this.width / 2 - 120, this.guiTop + 100, 117, 20, CommonComponents.GUI_DONE, p -> this.onDone(), null);
        this.addButton(this.width / 2 + 3, this.guiTop + 100, 118, 20, CommonComponents.GUI_CANCEL, p -> this.onClose(), null);
        this.editScheduleButton = this.addButton(this.width / 2 - 120, this.guiTop + 30, 200, 20, this.textEditSchedule, p -> this.minecraft.setScreen((Screen)new TrafficLightScheduleEditor((Screen)this, this.level, this.blockPos)), null);
        this.statusButton = this.addOnOffButton(this.width / 2 - 120, this.guiTop + 55, 240, 20, this.textStatus, this.status, (btn, value) -> {
            this.status = value;
        }, null);
        DLIconButton copyBtn = (DLIconButton)this.addRenderableWidget((GuiEventListener)ModGuiUtils.createCopyButton(this.width / 2 + 120 - 40, this.guiTop + 30, 20, 20, null, DynamicGuiRenderer.AreaStyle.NATIVE, btn -> {
            BlockEntity patt0$temp = this.level.getBlockEntity(this.blockPos);
            if (patt0$temp instanceof TrafficLightControllerBlockEntity) {
                TrafficLightControllerBlockEntity blockEntity = (TrafficLightControllerBlockEntity)patt0$temp;
                Clipboard.put(TrafficLightSchedule.class, (INBTSerializable)blockEntity.getFirstOrMainSchedule());
            }
        }));
        this.addTooltip(DLTooltip.of((FormattedText)Constants.textCopy).assignedTo((AbstractWidget)copyBtn));
        this.pasteButton = (DLIconButton)this.addRenderableWidget((GuiEventListener)ModGuiUtils.createPasteButton(this.width / 2 + 120 - 20, this.guiTop + 30, 20, 20, null, DynamicGuiRenderer.AreaStyle.NATIVE, btn -> {
            Optional schedule = Clipboard.get(TrafficLightSchedule.class);
            if (schedule.isPresent()) {
                DLNetworkManager.sendToServer((BaseNetworkPacket)new TrafficLightSchedulePacket(this.blockPos, List.of((TrafficLightSchedule)schedule.get())));
            }
        }));
        this.pasteButton.set_active(false);
        this.addTooltip(DLTooltip.of((FormattedText)Constants.textPaste).assignedTo((AbstractWidget)this.pasteButton));
    }

    protected void onDone() {
        DLNetworkManager.sendToServer((BaseNetworkPacket)new TrafficLightControllerPacket(this.blockPos, this.status));
        this.onClose();
    }

    public void tick() {
        super.tick();
        this.pasteButton.set_active(Clipboard.contains(TrafficLightSchedule.class));
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.width / 2), (int)this.guiTop, (FormattedText)title, (int)-1, (EAlignment)EAlignment.CENTER, (boolean)false);
    }
}

