/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.block.WritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.client.builtin.WritableSignScreen;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.TownSignBlock;
import de.mrjulsen.trafficcraft.block.data.TownSignVariant;
import de.mrjulsen.trafficcraft.block.entity.TownSignBlockEntity;
import de.mrjulsen.trafficcraft.network.packets.cts.TownSignPacket;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;

public class TownSignScreen
extends WritableSignScreen {
    private Component textVariant = TextUtils.translate((String)"gui.trafficcraft.townsignvariant");
    private TownSignVariant variant;
    private TownSignBlock.ETownSignSide side;

    public TownSignScreen(WritableSignBlockEntity pSign, TownSignBlock.ETownSignSide side) {
        this(pSign, TownSignScreen.getConfig(pSign, side), TownSignScreen.getState(pSign, side, (TownSignVariant)((Object)pSign.getBlockState().getValue(TownSignBlock.VARIANT))), TownSignScreen.getMessages(pSign, TownSignScreen.getConfig(pSign, side), side));
        this.variant = (TownSignVariant)((Object)pSign.getBlockState().getValue(TownSignBlock.VARIANT));
        this.side = side;
    }

    protected TownSignScreen(WritableSignBlockEntity pSign, WritableSignScreen.WritableSignConfig config, BlockState state, WritableSignScreen.ConfiguredLine[] messages) {
        super(pSign, config, state, messages);
    }

    protected static WritableSignScreen.WritableSignConfig getConfig(WritableSignBlockEntity pSign, TownSignBlock.ETownSignSide side) {
        if (pSign instanceof TownSignBlockEntity) {
            TownSignBlockEntity blockEntity = (TownSignBlockEntity)pSign;
            switch (side) {
                case BACK: {
                    return blockEntity.getBackRenderConfig();
                }
            }
        }
        return pSign.getRenderConfig();
    }

    protected static BlockState getState(WritableSignBlockEntity pSign, TownSignBlock.ETownSignSide side, TownSignVariant variant) {
        switch (side) {
            case BACK: {
                return (BlockState)pSign.getBlockState().getBlock().defaultBlockState().setValue(TownSignBlock.VARIANT, (Comparable)((Object)TownSignVariant.BACK));
            }
        }
        return (BlockState)pSign.getBlockState().getBlock().defaultBlockState().setValue(TownSignBlock.VARIANT, (Comparable)((Object)TownSignVariant.FRONT));
    }

    protected void init() {
        this.btnDone = this.addButton(this.width / 2 - 100, this.height / 4 + 145, 200, 20, CommonComponents.GUI_DONE, p_169820_ -> this.onDone(), null);
        this.addCycleButton("trafficcraft", TownSignVariant.class, this.width / 2 - 100, this.height / 4 + 120, 200, 20, this.textVariant, this.variant, (btn, value) -> {
            this.variant = value;
        }, null);
        this.signTextField = new TextFieldHelper(() -> this.messages[this.selectedLine].text, text -> {
            WritableSignBlockEntity patt0$temp = this.sign;
            if (patt0$temp instanceof TownSignBlockEntity) {
                TownSignBlockEntity blockEntity = (TownSignBlockEntity)patt0$temp;
                this.messages[this.selectedLine].text = text;
                switch (this.side) {
                    case BACK: {
                        blockEntity.setBackText((String)text, this.selectedLine);
                        return;
                    }
                }
            }
            this.sign.setText(text, this.selectedLine);
        }, TextFieldHelper.createClipboardGetter((Minecraft)this.minecraft), TextFieldHelper.createClipboardSetter((Minecraft)this.minecraft), text -> text == null || (float)this.minecraft.font.width(text) <= this.config.lineData()[this.selectedLine].maxLineWidth() * this.config.scale());
    }

    protected static WritableSignScreen.ConfiguredLine[] getMessages(WritableSignBlockEntity pSign, WritableSignScreen.WritableSignConfig config, TownSignBlock.ETownSignSide side) {
        if (pSign instanceof TownSignBlockEntity) {
            TownSignBlockEntity blockEntity = (TownSignBlockEntity)pSign;
            switch (side) {
                case BACK: {
                    return (WritableSignScreen.ConfiguredLine[])IntStream.range(0, config.lineData().length).mapToObj(i -> new WritableSignScreen.ConfiguredLine(blockEntity.getBackText(i), config.lineData()[i])).toArray(WritableSignScreen.ConfiguredLine[]::new);
                }
            }
        }
        return (WritableSignScreen.ConfiguredLine[])IntStream.range(0, config.lineData().length).mapToObj(i -> new WritableSignScreen.ConfiguredLine(pSign.getText(i), config.lineData()[i])).toArray(WritableSignScreen.ConfiguredLine[]::new);
    }

    public void removed() {
        DLNetworkManager.sendToServer((BaseNetworkPacket)new TownSignPacket(this.sign.getBlockPos(), (String[])Arrays.stream(this.messages).map(x -> x.text).toArray(String[]::new), this.variant, this.side));
    }

    protected void onDone() {
        DLNetworkManager.sendToServer((BaseNetworkPacket)new TownSignPacket(this.sign.getBlockPos(), (String[])Arrays.stream(this.messages).map(x -> x.text).toArray(String[]::new), this.variant, this.side));
        this.minecraft.setScreen(null);
    }
}

