/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client.screen;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCycleButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLSlider;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.network.packets.cts.StreetLampConfigPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class StreetLampScheduleScreen
extends DLScreen {
    public static final Component title = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.title");
    private int guiTop = 50;
    private static final int LINES = 3;
    private static final int SPACING_Y = 25;
    private static final int HEIGHT = 137;
    private int turnOnTime;
    private int turnOffTime;
    private TimeUtils.TimeFormat timeFormat = TimeUtils.TimeFormat.TICKS;
    protected DLSlider timeOnSlider;
    protected DLSlider timeOffSlider;
    protected DLCycleButton<TimeUtils.TimeFormat> timeFormatButton;
    private Component textTurnOnTime = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_on_time");
    private Component textTurnOffTime = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_off_time");
    private Component textTimeFormat = TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.time_format");

    public StreetLampScheduleScreen(int timeOn, int timeOff, TimeUtils.TimeFormat format) {
        super(title);
        this.turnOnTime = timeOn;
        this.turnOffTime = timeOff;
        this.timeFormat = format;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void init() {
        super.init();
        this.guiTop = this.height / 2 - 68;
        this.addButton(this.width / 2 - 100, this.guiTop + 112, 97, 20, CommonComponents.GUI_DONE, p -> this.onDone(), null);
        this.addButton(this.width / 2 + 3, this.guiTop + 112, 97, 20, CommonComponents.GUI_CANCEL, p -> this.onClose(), null);
        this.timeFormatButton = this.addCycleButton("dragonlib", TimeUtils.TimeFormat.class, this.width / 2 - 100, this.guiTop + 25, 200, 20, this.textTimeFormat, (Enum)this.timeFormat, (btn, value) -> {
            this.timeFormat = value;
        }, DLTooltip.of((String)"dragonlib", TimeUtils.TimeFormat.class));
        this.timeOnSlider = this.addSlider(this.width / 2 - 100, this.guiTop + 50, 200, 20, this.textTurnOnTime, (Component)TextUtils.text((String)""), 0.0, 23750.0, 250.0, this.turnOnTime, true, (slider, value) -> {
            this.turnOnTime = value.intValue();
        }, null, null);
        this.addRenderableWidget((GuiEventListener)this.timeOnSlider);
        this.timeOffSlider = this.addSlider(this.width / 2 - 100, this.guiTop + 75, 200, 20, this.textTurnOffTime, (Component)TextUtils.text((String)""), 0.0, 23750.0, 250.0, this.turnOffTime, true, (slider, value) -> {
            this.turnOffTime = value.intValue();
        }, null, null);
        this.addRenderableWidget((GuiEventListener)this.timeOffSlider);
    }

    protected void onDone() {
        DLNetworkManager.sendToServer((BaseNetworkPacket)new StreetLampConfigPacket(this.turnOnTime, this.turnOffTime, this.timeFormat));
        this.onClose();
    }

    private String getTimeSuffix(int value) {
        switch (value %= (int)DragonLib.ticksPerDay()) {
            case 0: {
                return "gui.trafficcraft.daytime.midnight";
            }
            case 6000: {
                return "gui.trafficcraft.daytime.morning";
            }
            case 12000: {
                return "gui.trafficcraft.daytime.noon";
            }
            case 18000: {
                return "gui.trafficcraft.daytime.evening";
            }
        }
        return null;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(graphics);
        graphics.drawCenteredString(this.font, this.getTitle(), this.width / 2, this.guiTop, 0xFFFFFF);
        String timeOnSuffix = this.getTimeSuffix(this.timeOnSlider.getValueInt());
        this.timeOnSlider.setMessage((Component)TextUtils.text((String)(TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_on_time", (Object[])new Object[]{TimeUtils.parseTime((long)this.timeOnSlider.getValueInt(), (TimeUtils.TimeFormat)this.timeFormat)}).getString() + (String)(timeOnSuffix == null ? "" : " (" + TextUtils.translate((String)timeOnSuffix).getString() + ")"))));
        String timeOffSuffix = this.getTimeSuffix(this.timeOffSlider.getValueInt());
        this.timeOffSlider.setMessage((Component)TextUtils.text((String)(TextUtils.translate((String)"gui.trafficcraft.streetlampconfig.turn_off_time", (Object[])new Object[]{TimeUtils.parseTime((long)this.timeOffSlider.getValueInt(), (TimeUtils.TimeFormat)this.timeFormat)}).getString() + (String)(timeOffSuffix == null ? "" : " (" + TextUtils.translate((String)timeOffSuffix).getString() + ")"))));
        super.render(graphics, mouseX, mouseY, partialTicks);
    }
}

