/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.client;

import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.components.BrushComponent;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.item.ColorPaletteItem;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TintedTextures {

    public static class TintedItem
    implements ItemColor {
        public int getColor(ItemStack pStack, int pTintIndex) {
            Item item = pStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                if (block instanceof IPaintableBlock) {
                    coloredBlock = (IPaintableBlock)block;
                    return coloredBlock.getDefaultColor();
                }
            } else {
                coloredBlock = pStack.getItem();
                if (coloredBlock instanceof BrushItem) {
                    BrushItem item2 = (BrushItem)coloredBlock;
                    if (pTintIndex == 1) {
                        return 0xFF000000 | PaintColor.getByIndex(((BrushComponent)item2.getComponent(pStack)).colorId()).getTextureColor() & 0xFFFFFF;
                    }
                    return -1;
                }
                if (pStack.getItem() instanceof ColorPaletteItem) {
                    if (pTintIndex == 0) {
                        return -1;
                    }
                    int color = ColorPaletteItem.getColorAt(pStack, pTintIndex - 1);
                    if (color == 0) {
                        color = -1;
                    }
                    return color;
                }
            }
            return 0;
        }
    }

    public static class TintedBlock
    implements BlockColor {
        public int getColor(BlockState pState, BlockAndTintGetter pLevel, BlockPos pPos, int pTintIndex) {
            Block block = pState.getBlock();
            if (block instanceof IPaintableBlock) {
                IPaintableBlock block2 = (IPaintableBlock)block;
                if (pLevel == null) {
                    return block2.getDefaultColor();
                }
                BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
                if (blockEntity instanceof IColorBlockEntity) {
                    IColorBlockEntity blockEntity2 = (IColorBlockEntity)blockEntity;
                    PaintColor c = blockEntity2.getColor();
                    return c == PaintColor.NONE ? block2.getDefaultColor() : c.getTextureColor();
                }
            }
            return 0;
        }
    }
}

