/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.net.BaseNetworkPacket;
import de.mrjulsen.mcdragonlib.net.DLNetworkManager;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.trafficcraft.block.TrafficSignBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficSignShape;
import de.mrjulsen.trafficcraft.data.NamedTrafficSignTextureReference;
import de.mrjulsen.trafficcraft.data.TrafficSignClientTexture;
import de.mrjulsen.trafficcraft.data.TrafficSignTextureData;
import de.mrjulsen.trafficcraft.network.packets.stc.TrafficSignTextureResetPacket;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import dev.architectury.utils.GameInstance;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrafficSignBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_LEGACY_TEXTURE = "texture";
    private static final String NBT_TEXTURE = "SignTexture";
    private String textureId;
    private TrafficSignClientTexture texture;

    protected TrafficSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrafficSignBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAFFIC_SIGN_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(NBT_LEGACY_TEXTURE)) {
            this.migrate(tag.getString(NBT_LEGACY_TEXTURE));
        } else if (tag.contains(NBT_TEXTURE)) {
            this.setTextureId(tag.getString(NBT_TEXTURE));
        }
    }

    private void migrate(String base64) {
        new Thread(() -> {
            while (this.getLevel() == null) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.getLevel().isClientSide) {
                return;
            }
            GameInstance.getServer().execute(() -> {
                BlockState state = this.getLevel().getBlockState(this.getBlockPos());
                TrafficSignTextureData data = new TrafficSignTextureData((TrafficSignShape)((Object)((Object)((Object)state.getValue(TrafficSignBlock.SHAPE)))), Base64.getDecoder().decode(base64), 32, 32, System.currentTimeMillis(), new UUID(0L, 0L));
                data.save();
                this.setTextureId(data.getHash().toString());
            });
        }, "Traffic Sign Migration").start();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.textureId != null) {
            tag.putString(NBT_TEXTURE, this.getTextureId());
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.resetTexture();
    }

    public String getTextureId() {
        return this.textureId;
    }

    public TrafficSignClientTexture getClientTexture() {
        if (this.texture == null) {
            if (this.getTextureId() == null || this.getTextureId().equals("empty")) {
                return TrafficSignClientTexture.EMPTY;
            }
            this.texture = TrafficSignClientTexture.load(this.getTextureId(), true);
        }
        return this.texture;
    }

    public void resetTexture() {
        if (this.level.isClientSide) {
            DLUtils.doIfNotNull((Object)this.texture, x -> x.close());
            this.texture = null;
        }
    }

    public void setAndResetTexture(NamedTrafficSignTextureReference texture) {
        this.setTextureId(texture.getTextureId());
        if (!this.level.isClientSide) {
            for (ServerPlayer player : (ServerPlayer[])this.level.players().stream().filter(p -> p instanceof ServerPlayer).toArray(ServerPlayer[]::new)) {
                DLNetworkManager.sendToPlayer((ServerPlayer)player, (BaseNetworkPacket)new TrafficSignTextureResetPacket(this.getBlockPos()));
            }
        }
    }

    public void setTextureId(String id) {
        this.textureId = id;
        this.notifyUpdate();
    }
}

