/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.core.Location;
import de.mrjulsen.trafficcraft.block.TrafficLightRequestButtonBlock;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightControllerBlockEntity;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TrafficLightRequestButtonBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_LISTENING = "listening";
    private static final String NBT_LINKED_TO = "linkedTo";
    private Location linkLocation;
    private boolean listening;

    protected TrafficLightRequestButtonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrafficLightRequestButtonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_REQUEST_BUTTON_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.listening = tag.getBoolean(NBT_LISTENING);
        if (tag.contains(NBT_LINKED_TO)) {
            this.linkLocation = Location.fromNbt((CompoundTag)tag.getCompound(NBT_LINKED_TO));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean(NBT_LISTENING, this.listening);
        if (this.linkLocation != null) {
            tag.put(NBT_LINKED_TO, (Tag)this.linkLocation.toNbt());
        }
    }

    private void tick(Level level, BlockPos pos, BlockState state) {
        if (this.listening && !level.isClientSide) {
            boolean isRunning = false;
            if (this.linkLocation != null) {
                BlockEntity blockEntity = level.getBlockEntity(this.linkLocation.getLocationBlockPos());
                if (blockEntity instanceof TrafficLightBlockEntity) {
                    TrafficLightBlockEntity blockEntity2 = (TrafficLightBlockEntity)blockEntity;
                    isRunning = blockEntity2.isFirstIteration();
                } else {
                    blockEntity = level.getBlockEntity(this.linkLocation.getLocationBlockPos());
                    if (blockEntity instanceof TrafficLightControllerBlockEntity) {
                        TrafficLightControllerBlockEntity blockEntity3 = (TrafficLightControllerBlockEntity)blockEntity;
                        isRunning = blockEntity3.isFirstIteration();
                    }
                }
            }
            if (!isRunning) {
                this.listening = false;
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)TrafficLightRequestButtonBlock.ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)TrafficLightRequestButtonBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TrafficLightRequestButtonBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public void linkTo(Location loc) {
        this.linkLocation = loc;
        this.notifyUpdate();
    }

    public void clearLink() {
        this.linkLocation = null;
        this.notifyUpdate();
    }

    public Location getLinkLocation() {
        return this.linkLocation;
    }

    public boolean isValidLinked() {
        return this.getLinkLocation() != null && (this.level.getBlockEntity(this.linkLocation.getLocationBlockPos()) instanceof TrafficLightControllerBlockEntity || this.level.getBlockEntity(this.linkLocation.getLocationBlockPos()) instanceof TrafficLightBlockEntity);
    }

    public boolean isListening() {
        return this.listening;
    }

    public boolean activate() {
        if (!this.isValidLinked()) {
            return false;
        }
        this.listening = true;
        BlockEntity blockEntity = this.level.getBlockEntity(this.linkLocation.getLocationBlockPos());
        if (blockEntity instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity2 = (TrafficLightBlockEntity)blockEntity;
            if (blockEntity2.getSchedule().getTrigger() == TrafficLightTrigger.ON_REQUEST) {
                blockEntity2.startSchedule(true);
                return true;
            }
        } else {
            TrafficLightControllerBlockEntity blockEntity3;
            blockEntity = this.level.getBlockEntity(this.linkLocation.getLocationBlockPos());
            if (blockEntity instanceof TrafficLightControllerBlockEntity && (blockEntity3 = (TrafficLightControllerBlockEntity)blockEntity).getFirstOrMainSchedule().getTrigger() == TrafficLightTrigger.ON_REQUEST) {
                blockEntity3.startSchedule(true);
                return true;
            }
        }
        this.listening = false;
        return false;
    }
}

