/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.block.SyncedBlockEntity;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.trafficcraft.block.StreetLampBaseBlock;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StreetLampBlockEntity
extends SyncedBlockEntity {
    private static final String NBT_TURN_ON_TIME = "turnOnTime";
    private static final String NBT_TURN_OFF_TIME = "turnOffTime";
    private int onTimeTicks = 0;
    private int offTimeTicks = 0;

    protected StreetLampBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public StreetLampBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STREET_LAMP_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.onTimeTicks = tag.getInt(NBT_TURN_ON_TIME);
        this.offTimeTicks = tag.getInt(NBT_TURN_OFF_TIME);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt(NBT_TURN_ON_TIME, this.onTimeTicks);
        tag.putInt(NBT_TURN_OFF_TIME, this.offTimeTicks);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.getOffTime() == this.getOnTime()) {
            return;
        }
        if (TimeUtils.isInRange((long)((int)(level.getDayTime() % DragonLib.ticksPerDay())), (long)this.onTimeTicks, (long)this.offTimeTicks)) {
            if (!((Boolean)state.getValue((Property)StreetLampBaseBlock.LIT)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StreetLampBaseBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
        } else if (((Boolean)state.getValue((Property)StreetLampBaseBlock.LIT)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StreetLampBaseBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, StreetLampBlockEntity blockEntity) {
        blockEntity.tick(level, pos, state);
    }

    public int getOnTime() {
        return this.onTimeTicks;
    }

    public int getOffTime() {
        return this.offTimeTicks;
    }

    public void setOnTime(int time) {
        this.onTimeTicks = Mth.clamp((int)time, (int)0, (int)((int)DragonLib.ticksPerDay() - 1));
        this.notifyUpdate();
    }

    public void setOffTime(int time) {
        this.offTimeTicks = Mth.clamp((int)time, (int)0, (int)((int)DragonLib.ticksPerDay() - 1));
        this.notifyUpdate();
    }
}

