/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.entity;

import de.mrjulsen.mcdragonlib.block.WritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.client.builtin.WritableSignScreen;
import de.mrjulsen.trafficcraft.block.WritableTrafficSign;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;

public class HouseNumberSignBlockEntity
extends WritableSignBlockEntity
implements IColorBlockEntity {
    private PaintColor color = PaintColor.NONE;

    protected HouseNumberSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public HouseNumberSignBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HOUSE_NUMBER_SIGN_BLOCK_ENTITY.get(), pos, state);
    }

    public WritableSignScreen.WritableSignConfig getRenderConfig() {
        int y = 120;
        int maxScale = 3;
        return new WritableSignScreen.WritableSignConfig(new WritableSignScreen.ConfiguredLineData[]{new WritableSignScreen.ConfiguredLineData(0.0f, 0.03125f, new Vec2(1.0f, 1.0f), new Vec2((float)maxScale, (float)maxScale), 0.5f, (float)maxScale, 0)}, false, 0.0f, (float)y, 96.0f, 0.0f, 0.0f, 0.0f, -0.45f, blockState -> Float.valueOf(blockState.getValue((Property)WritableTrafficSign.FACING) == Direction.EAST || blockState.getValue((Property)WritableTrafficSign.FACING) == Direction.WEST ? ((Direction)blockState.getValue((Property)WritableTrafficSign.FACING)).getOpposite().toYRot() : ((Direction)blockState.getValue((Property)WritableTrafficSign.FACING)).toYRot()), PaintColor.useWhiteOrBlackForeColor(this.getColor().getTextureColor()) ? DyeColor.WHITE.getTextColor() : DyeColor.BLACK.getTextColor());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.color = PaintColor.getByIndex(tag.getInt("color"));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("color", this.color.getIndex());
    }

    @Override
    public void setColor(PaintColor color) {
        this.color = color;
        this.notifyUpdate();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 512);
    }

    @Override
    public PaintColor getColor() {
        return this.color;
    }
}

