/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import com.mojang.serialization.Codec;
import de.mrjulsen.trafficcraft.registry.ModBlocks;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;

public enum RoadType implements StringRepresentable
{
    NONE("none", 0, -1, ModBlocks.ASPHALT),
    ASPHALT("asphalt", 1, -13159374, ModBlocks.ASPHALT),
    CONCRETE("concrete", 2, -4607065, ModBlocks.CONCRETE);

    private String roadType;
    private int index;
    private int color;
    private RegistrySupplier<Block> pickupBlock;
    public static final Codec<RoadType> CODEC;

    private RoadType(String roadType, int index, int color, RegistrySupplier<Block> pickupBlock) {
        this.roadType = roadType;
        this.index = index;
        this.color = color;
        this.pickupBlock = pickupBlock;
    }

    public String getRoadType() {
        return this.roadType;
    }

    public RegistrySupplier<Block> getPickupBlock() {
        return this.pickupBlock;
    }

    public int getIndex() {
        return this.index;
    }

    public int getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return String.format("gui.trafficcraft.road.roadtype.%s", this.roadType);
    }

    public static RoadType getRoadTypeByIndex(int index) {
        for (RoadType controlType : RoadType.values()) {
            if (controlType.getIndex() != index) continue;
            return controlType;
        }
        return NONE;
    }

    public String getSerializedName() {
        return this.roadType;
    }

    public Block getBlock() {
        switch (this.ordinal()) {
            default: {
                return (Block)ModBlocks.ASPHALT.get();
            }
            case 2: 
        }
        return (Block)ModBlocks.CONCRETE.get();
    }

    public Block getSlope() {
        switch (this.ordinal()) {
            default: {
                return (Block)ModBlocks.ASPHALT_SLOPE.get();
            }
            case 2: 
        }
        return (Block)ModBlocks.CONCRETE_SLOPE.get();
    }

    static {
        CODEC = ExtraCodecs.idResolverCodec(RoadType::getIndex, RoadType::getRoadTypeByIndex, (int)0);
    }
}

