/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block.data;

import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.item.BrushItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IPaintableBlock {
    default public void onRemoveColor(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack = pPlayer.getInventory().getSelected();
        Item item = stack.getItem();
        if (!(item instanceof BrushItem)) {
            return;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof IColorBlockEntity) {
            IColorBlockEntity blockEntity2 = (IColorBlockEntity)blockEntity;
            if (blockEntity2.getColor() == PaintColor.NONE) {
                return;
            }
            blockEntity2.setColor(PaintColor.NONE);
            pLevel.playSound(null, pPos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
        }
    }

    default public InteractionResult onSetColor(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        ItemStack stack = pContext.getItemInHand();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IColorBlockEntity) {
            IColorBlockEntity blockEntity2 = (IColorBlockEntity)blockEntity;
            blockEntity = stack.getItem();
            if (blockEntity instanceof BrushItem) {
                BrushItem item = (BrushItem)blockEntity;
                blockEntity2.setColor(item.getColor(stack));
                if (!level.isClientSide) {
                    level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.FAIL;
    }

    default public InteractionResult update(UseOnContext pContext) {
        return InteractionResult.FAIL;
    }

    default public int getDefaultColor() {
        return -1;
    }
}

