/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.data.TrafficLightColor;
import de.mrjulsen.trafficcraft.block.data.TrafficLightModel;
import de.mrjulsen.trafficcraft.block.data.TrafficLightTrigger;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightDirection;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightMode;
import de.mrjulsen.trafficcraft.block.data.compat.TrafficLightVariant;
import de.mrjulsen.trafficcraft.block.entity.TrafficLightBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import de.mrjulsen.trafficcraft.registry.ModBlockEntities;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrafficLightBlock
extends ColorableBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final MapCodec<TrafficLightBlock> CODEC = TrafficLightBlock.simpleCodec(TrafficLightBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<TrafficLightModel> MODEL = EnumProperty.create((String)"model", TrafficLightModel.class);
    @Deprecated
    public static final EnumProperty<TrafficLightVariant> VARIANT = EnumProperty.create((String)"variant", TrafficLightVariant.class);
    @Deprecated
    public static final EnumProperty<TrafficLightDirection> DIRECTION = EnumProperty.create((String)"direction", TrafficLightDirection.class);
    @Deprecated
    public static final EnumProperty<TrafficLightMode> MODE = EnumProperty.create((String)"mode", TrafficLightMode.class);
    public static final VoxelShape SHAPE_COMMON = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final Map<TrafficLightModel, Map<Direction, VoxelShape>> shapes = new HashMap<TrafficLightModel, Map<Direction, VoxelShape>>();

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public TrafficLightBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(5.0f).requiresCorrectToolForDrops().sound(SoundType.ANVIL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(MODEL, (Comparable)((Object)TrafficLightModel.THREE_LIGHTS)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(MODEL, (Comparable)((Object)TrafficLightModel.THREE_LIGHTS)));
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)shapes.get(pState.getValue(MODEL)).get((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{WATERLOGGED, FACING, MODEL});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (item instanceof BrushItem) {
            return ItemInteractionResult.FAIL;
        }
        if (level.isClientSide && item instanceof WrenchItem) {
            if (!player.isShiftKeyDown()) {
                ClientWrapper.showTrafficLightConfigScreen(level, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof TrafficLightBlockEntity) {
            TrafficLightBlockEntity blockEntity2 = (TrafficLightBlockEntity)blockEntity;
            if (pLevel.hasNeighborSignal(pPos)) {
                if (blockEntity2.getSchedule().getTrigger() == TrafficLightTrigger.REDSTONE && !blockEntity2.isPowered()) {
                    blockEntity2.setPowered(true);
                    blockEntity2.startSchedule(true);
                }
            } else {
                blockEntity2.setPowered(false);
                if (blockEntity2.getSchedule().getTrigger() == TrafficLightTrigger.REDSTONE) {
                    blockEntity2.stopSchedule();
                }
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    private static int calcStateFlag(Collection<TrafficLightColor> colors) {
        int flag = 0;
        if (colors.contains((Object)TrafficLightColor.GREEN) || colors.contains((Object)TrafficLightColor.F1_F2_F3_F5)) {
            flag |= 1;
        }
        if (colors.contains((Object)TrafficLightColor.YELLOW) || colors.contains((Object)TrafficLightColor.F4)) {
            flag |= 2;
        }
        if (colors.contains((Object)TrafficLightColor.RED) || colors.contains((Object)TrafficLightColor.F0)) {
            flag |= 4;
        }
        return flag;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof TrafficLightBlockEntity)) {
            return 0;
        }
        TrafficLightBlockEntity be = (TrafficLightBlockEntity)blockEntity;
        int flag = TrafficLightBlock.calcStateFlag(be.getEnabledColors()) * 2;
        return flag;
    }

    @Override
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TrafficLightBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TrafficLightBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.TRAFFIC_LIGHT_BLOCK_ENTITY.get()), TrafficLightBlockEntity::tick);
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pDirection != pState.getValue((Property)FACING);
    }

    static {
        Arrays.stream(TrafficLightModel.values()).forEach(x -> {
            HashMap<Direction, VoxelShape> voxelShapes = new HashMap<Direction, VoxelShape>();
            voxelShapes.put(Direction.NORTH, Block.box((double)4.0, (double)x.getHitboxBottom(), (double)1.0, (double)12.0, (double)x.getHitboxTop(), (double)6.0));
            voxelShapes.put(Direction.SOUTH, Block.box((double)4.0, (double)x.getHitboxBottom(), (double)10.0, (double)12.0, (double)x.getHitboxTop(), (double)15.0));
            voxelShapes.put(Direction.EAST, Block.box((double)10.0, (double)x.getHitboxBottom(), (double)4.0, (double)15.0, (double)x.getHitboxTop(), (double)12.0));
            voxelShapes.put(Direction.WEST, Block.box((double)1.0, (double)x.getHitboxBottom(), (double)4.0, (double)6.0, (double)x.getHitboxTop(), (double)12.0));
            shapes.put((TrafficLightModel)x, (Map<Direction, VoxelShape>)voxelShapes);
        });
    }
}

