/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.WritableTrafficSign;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.data.TownSignVariant;
import de.mrjulsen.trafficcraft.block.entity.TownSignBlockEntity;
import de.mrjulsen.trafficcraft.client.ClientWrapper;
import de.mrjulsen.trafficcraft.item.BrushItem;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TownSignBlock
extends WritableTrafficSign
implements ITrafficPostLike {
    public static final MapCodec<TownSignBlock> CODEC = TownSignBlock.simpleCodec(TownSignBlock::new);
    private static final VoxelShape SHAPE_COMMON = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.box((double)0.0, (double)4.0, (double)9.0, (double)16.0, (double)16.0, (double)9.5));
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.box((double)0.0, (double)4.0, (double)6.5, (double)16.0, (double)16.0, (double)7.0));
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.box((double)9.0, (double)4.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)Block.box((double)6.5, (double)4.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0));
    public static final EnumProperty<TownSignVariant> VARIANT = EnumProperty.create((String)"variant", TownSignVariant.class);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public TownSignBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(1.0f).requiresCorrectToolForDrops().sound(SoundType.LANTERN));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(VARIANT, (Comparable)((Object)TownSignVariant.FRONT)));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            case NORTH: {
                return pState.getValue(VARIANT) == TownSignVariant.BOTH ? Shapes.or((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH) : SHAPE_NORTH;
            }
            case SOUTH: {
                return pState.getValue(VARIANT) == TownSignVariant.BOTH ? Shapes.or((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH) : SHAPE_SOUTH;
            }
            case EAST: {
                return pState.getValue(VARIANT) == TownSignVariant.BOTH ? Shapes.or((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST) : SHAPE_EAST;
            }
            case WEST: {
                return pState.getValue(VARIANT) == TownSignVariant.BOTH ? Shapes.or((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST) : SHAPE_WEST;
            }
        }
        return SHAPE_COMMON;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{VARIANT});
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ETownSignSide editSide;
        Item item = stack.getItem();
        if (item instanceof BrushItem) {
            return ItemInteractionResult.FAIL;
        }
        switch ((TownSignVariant)((Object)state.getValue(VARIANT))) {
            case BACK: {
                editSide = ETownSignSide.BACK;
                break;
            }
            case BOTH: {
                if (hitResult.getDirection() == state.getValue((Property)FACING)) {
                    editSide = ETownSignSide.FRONT;
                    break;
                }
                if (hitResult.getDirection() == ((Direction)state.getValue((Property)FACING)).getOpposite()) {
                    editSide = ETownSignSide.BACK;
                    break;
                }
                return ItemInteractionResult.FAIL;
            }
            default: {
                editSide = ETownSignSide.FRONT;
            }
        }
        if (level.isClientSide && item instanceof WrenchItem && (blockEntity = level.getBlockEntity(pos)) instanceof TownSignBlockEntity) {
            TownSignBlockEntity blockEntity2 = (TownSignBlockEntity)blockEntity;
            if (!player.isShiftKeyDown()) {
                ClientWrapper.showTownSignScreen(blockEntity2, editSide);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new TownSignBlockEntity(pPos, pState);
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return pState.getValue(VARIANT) != TownSignVariant.BOTH && pDirection == ((Direction)pState.getValue((Property)FACING)).getOpposite();
    }

    public static enum ETownSignSide implements StringRepresentable
    {
        FRONT("front", 0),
        BACK("back", 1);

        private String side;
        private int index;

        private ETownSignSide(String variant, int index) {
            this.side = variant;
            this.index = index;
        }

        public String getSide() {
            return this.side;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTranslationKey() {
            return String.format("gui.trafficcraft.town_sign.variant.%s", this.side);
        }

        public static ETownSignSide getSideByIndex(int index) {
            for (ETownSignSide shape : ETownSignSide.values()) {
                if (shape.getIndex() != index) continue;
                return shape;
            }
            return FRONT;
        }

        public String getSerializedName() {
            return this.side;
        }
    }
}

