/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.WritableTrafficSign;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.entity.StreetSignBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StreetSignBlock
extends WritableTrafficSign
implements ITrafficPostLike,
IPaintableBlock {
    public static final MapCodec<StreetSignBlock> CODEC = StreetSignBlock.simpleCodec(StreetSignBlock::new);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)7.5, (double)10.5, (double)6.0, (double)8.5, (double)14.5, (double)23.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)7.5, (double)10.5, (double)-7.0, (double)8.5, (double)14.5, (double)10.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)6.0, (double)10.5, (double)7.5, (double)23.0, (double)14.5, (double)8.5);
    public static final VoxelShape SHAPE_EAST = Block.box((double)-7.0, (double)10.5, (double)7.5, (double)10.0, (double)14.5, (double)8.5);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public StreetSignBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.SNOW).strength(0.2f).sound(SoundType.BAMBOO));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.onRemoveColor(pState, pLevel, pPos, pPlayer);
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new StreetSignBlockEntity(pPos, pState);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        return this.canAttachTo((BlockGetter)pLevel, pPos.relative(direction.getOpposite()), direction);
    }

    private boolean canAttachTo(BlockGetter pBlockReader, BlockPos pPos, Direction pDirection) {
        BlockState blockstate = pBlockReader.getBlockState(pPos);
        Block block = blockstate.getBlock();
        if (block instanceof ITrafficPostLike) {
            ITrafficPostLike postLike = (ITrafficPostLike)block;
            return postLike.canAttach(blockstate, pPos, pDirection);
        }
        return false;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.getOpposite() == pState.getValue((Property)FACING) && !pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate;
        if (!pContext.replacingClickedOnBlock() && (blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(pContext.getClickedFace().getOpposite()))).is((Block)this) && blockstate.getValue((Property)FACING) == pContext.getClickedFace()) {
            return null;
        }
        BlockState blockstate1 = this.defaultBlockState();
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        for (Direction direction : pContext.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockstate1 = (BlockState)blockstate1.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate1.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return false;
    }
}

