/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.ITrafficPostLike;
import de.mrjulsen.trafficcraft.block.entity.StreetLampBlockEntity;
import de.mrjulsen.trafficcraft.item.WrenchItem;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StreetLampBaseBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
ITrafficPostLike {
    public static final MapCodec<StreetLampBaseBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StreetLampBaseBlock.propertiesCodec(), (App)LampType.CODEC.fieldOf("lamp_type").forGetter(StreetLampBaseBlock::getLampType)).apply((Applicative)instance, StreetLampBaseBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_COMMON = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    public static final VoxelShape SHAPE_PART_NORTH = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)11.0, (double)25.0);
    public static final VoxelShape SHAPE_PART_SOUTH = Block.box((double)6.0, (double)4.0, (double)-9.0, (double)10.0, (double)11.0, (double)10.0);
    public static final VoxelShape SHAPE_PART_EAST = Block.box((double)6.0, (double)4.0, (double)6.0, (double)25.0, (double)11.0, (double)10.0);
    public static final VoxelShape SHAPE_PART_WEST = Block.box((double)-9.0, (double)4.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);
    public static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_NORTH);
    public static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_SOUTH);
    public static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_EAST);
    public static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_PART_WEST);
    public static final VoxelShape SHAPE_SMALL_PART_NORTH = Block.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)17.0);
    public static final VoxelShape SHAPE_SMALL_PART_SOUTH = Block.box((double)6.0, (double)11.0, (double)-1.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_SMALL_PART_EAST = Block.box((double)6.0, (double)11.0, (double)6.0, (double)17.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_SMALL_PART_WEST = Block.box((double)-1.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_SMALL_SOUTH = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_NORTH);
    public static final VoxelShape SHAPE_SMALL_NORTH = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_SOUTH);
    public static final VoxelShape SHAPE_SMALL_EAST = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_EAST);
    public static final VoxelShape SHAPE_SMALL_WEST = Shapes.or((VoxelShape)SHAPE_COMMON, (VoxelShape)SHAPE_SMALL_PART_WEST);
    private LampType lampType;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public StreetLampBaseBlock(BlockBehaviour.Properties properties, LampType type) {
        super(properties.mapColor(MapColor.METAL).strength(2.0f).requiresCorrectToolForDrops().sound(SoundType.METAL).lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 15 : 0));
        this.lampType = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public LampType getLampType() {
        return this.lampType;
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_COMMON;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (this.lampType == LampType.SMALL || this.lampType == LampType.SMALL_DOUBLE) {
            switch ((Direction)pState.getValue((Property)FACING)) {
                case NORTH: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_NORTH : Shapes.or((VoxelShape)SHAPE_SMALL_NORTH, (VoxelShape)SHAPE_SMALL_SOUTH);
                }
                case SOUTH: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_SOUTH : Shapes.or((VoxelShape)SHAPE_SMALL_NORTH, (VoxelShape)SHAPE_SMALL_SOUTH);
                }
                case EAST: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_EAST : Shapes.or((VoxelShape)SHAPE_SMALL_EAST, (VoxelShape)SHAPE_SMALL_WEST);
                }
                case WEST: {
                    return this.lampType == LampType.SMALL ? SHAPE_SMALL_WEST : Shapes.or((VoxelShape)SHAPE_SMALL_EAST, (VoxelShape)SHAPE_SMALL_WEST);
                }
            }
            return SHAPE_COMMON;
        }
        if (this.lampType == LampType.NORMAL || this.lampType == LampType.DOUBLE) {
            switch ((Direction)pState.getValue((Property)FACING)) {
                case NORTH: {
                    return this.lampType == LampType.NORMAL ? SHAPE_NORTH : Shapes.or((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH);
                }
                case SOUTH: {
                    return this.lampType == LampType.NORMAL ? SHAPE_SOUTH : Shapes.or((VoxelShape)SHAPE_NORTH, (VoxelShape)SHAPE_SOUTH);
                }
                case EAST: {
                    return this.lampType == LampType.NORMAL ? SHAPE_EAST : Shapes.or((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST);
                }
                case WEST: {
                    return this.lampType == LampType.NORMAL ? SHAPE_WEST : Shapes.or((VoxelShape)SHAPE_EAST, (VoxelShape)SHAPE_WEST);
                }
            }
            return SHAPE_COMMON;
        }
        return SHAPE_COMMON;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (item instanceof WrenchItem) {
            if (!level.isClientSide) {
                StreetLampBlockEntity blockEntity;
                BlockEntity blockEntity2 = level.getBlockEntity(pos);
                if (blockEntity2 instanceof StreetLampBlockEntity && (blockEntity = (StreetLampBlockEntity)blockEntity2).getOnTime() != blockEntity.getOffTime()) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)TextUtils.translate((String)"block.trafficcraft.street_lamp.use.error_scheduled"), true);
                        return ItemInteractionResult.FAIL;
                    }
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)LIT) == false)));
                }
            } else {
                level.playSound(player, pos, SoundEvents.COMPARATOR_CLICK, SoundSource.BLOCKS, 0.3f, 0.5f);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING, LIT, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new StreetLampBlockEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (!pLevel.isClientSide) {
            return (level, pos, state, blockEntity) -> {
                long tickCount = level.getGameTime();
                if (tickCount % 50L == 0L) {
                    ((StreetLampBlockEntity)blockEntity).tick(level, pos, state);
                }
            };
        }
        return null;
    }

    @Override
    public boolean canAttach(BlockState pState, BlockPos pPos, Direction pDirection) {
        return false;
    }

    @Override
    public boolean canConnect(BlockState pState, Direction pDirection) {
        return pDirection == Direction.DOWN;
    }

    public static enum LampType {
        NORMAL(0),
        SMALL(1),
        DOUBLE(2),
        SMALL_DOUBLE(3),
        SINGLE_LIGHT(4);

        private int id;
        public static final Codec<LampType> CODEC;

        private LampType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static LampType getFromId(int id) {
            return Arrays.stream(LampType.values()).filter(x -> x.getId() == id).findFirst().orElse(NORMAL);
        }

        static {
            CODEC = ExtraCodecs.idResolverCodec(LampType::getId, LampType::getFromId, (int)0);
        }
    }
}

