/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import de.mrjulsen.trafficcraft.block.data.IColorBlockEntity;
import de.mrjulsen.trafficcraft.block.entity.ColoredBlockEntity;
import de.mrjulsen.trafficcraft.components.BrushComponent;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.item.BrushItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaintBucketBlock
extends ColorableBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<PaintBucketBlock> CODEC = PaintBucketBlock.simpleCodec(PaintBucketBlock::new);
    public static final int MAX_PAINT = 8;
    public static final IntegerProperty PAINT = IntegerProperty.create((String)"paint", (int)0, (int)8);
    public static final DirectionProperty DIRECTION = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape PAINT_BUCKET = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public PaintBucketBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(2.0f).noOcclusion().sound(SoundType.LANTERN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PAINT, (Comparable)Integer.valueOf(0))).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return PAINT_BUCKET;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{PAINT, DIRECTION, WATERLOGGED});
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PaintBucketBlock.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.below(), (Direction)Direction.UP);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)DIRECTION, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)DIRECTION)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)DIRECTION)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        FluidState fluidState = pContext.getLevel().getFluidState(pos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PAINT, (Comparable)Integer.valueOf(0))).setValue((Property)DIRECTION, (Comparable)pContext.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            player.displayClientMessage((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.underwater").withStyle(ChatFormatting.RED), true);
            return ItemInteractionResult.FAIL;
        }
        if (!(level.getBlockEntity(pos) instanceof ColoredBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        IColorBlockEntity blockEntity = (IColorBlockEntity)level.getBlockEntity(pos);
        Item item = stack.getItem();
        if (item instanceof BrushItem) {
            BrushItem item2 = (BrushItem)item;
            int paint = (Integer)state.getValue((Property)PAINT);
            if (paint <= 0) {
                if (!level.isClientSide) {
                    player.displayClientMessage((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.empty").withStyle(ChatFormatting.RED), true);
                }
                return ItemInteractionResult.FAIL;
            }
            BrushComponent comp = (BrushComponent)item2.getComponent(stack);
            if (comp.paintAmount() < item2.getMaxPaint() && paint > 0 || comp.paintAmount() == item2.getMaxPaint() && comp.colorId() != blockEntity.getColor().getIndex()) {
                if (!level.isClientSide) {
                    if (!player.isCreative()) {
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PAINT) - 1)));
                    }
                    item2.setComponent(stack, new BrushComponent(comp.patternId(), item2.getMaxPaint(), blockEntity.getColor().getIndex()));
                    level.playSound(player, pos, SoundEvents.BUCKET_EMPTY_LAVA, SoundSource.BLOCKS, 0.8f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
        } else {
            item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if ((Integer)state.getValue((Property)PAINT) > 0 && !blockEntity.getColor().equals((Object)PaintColor.getByDye(dye))) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.wrong_color").withStyle(ChatFormatting.RED), true);
                    }
                    return ItemInteractionResult.FAIL;
                }
                if ((Integer)state.getValue((Property)PAINT) >= 8) {
                    if (!level.isClientSide) {
                        player.displayClientMessage((Component)TextUtils.translate((String)"block.trafficcraft.paint_bucket.message.full").withStyle(ChatFormatting.YELLOW), true);
                    }
                    return ItemInteractionResult.FAIL;
                }
                if ((Integer)state.getValue((Property)PAINT) < 8) {
                    blockEntity.setColor(PaintColor.getByDye(dye));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PAINT, (Comparable)Integer.valueOf((Integer)state.getValue((Property)PAINT) + 1)));
                    if (!level.isClientSide) {
                        if (!player.isCreative()) {
                            player.getItemInHand(hand).shrink(1);
                        }
                        level.playSound(null, pos, SoundEvents.BUCKET_FILL_LAVA, SoundSource.BLOCKS, 0.8f, 0.9f);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.FAIL;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    public void onRemoveColor(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
    }

    @Override
    public InteractionResult onSetColor(UseOnContext pContext) {
        return InteractionResult.SUCCESS;
    }
}

