/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.WritableTrafficSign;
import de.mrjulsen.trafficcraft.block.data.IPaintableBlock;
import de.mrjulsen.trafficcraft.block.entity.HouseNumberSignBlockEntity;
import de.mrjulsen.trafficcraft.data.PaintColor;
import de.mrjulsen.trafficcraft.item.BrushItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HouseNumberSignBlock
extends WritableTrafficSign
implements IPaintableBlock {
    public static final MapCodec<HouseNumberSignBlock> CODEC = HouseNumberSignBlock.simpleCodec(HouseNumberSignBlock::new);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)1.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)15.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0);

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public HouseNumberSignBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.SNOW).strength(0.2f).sound(SoundType.BAMBOO));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.getValue((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    public void attack(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        this.onRemoveColor(pState, pLevel, pPos, pPlayer);
    }

    @Override
    public void onRemoveColor(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack stack = pPlayer.getInventory().getSelected();
        Item item = stack.getItem();
        if (!(item instanceof BrushItem)) {
            return;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof HouseNumberSignBlockEntity) {
            HouseNumberSignBlockEntity blockEntity2 = (HouseNumberSignBlockEntity)blockEntity;
            if (blockEntity2.getColor() == PaintColor.NONE) {
                return;
            }
            blockEntity2.setColor(PaintColor.NONE);
            pLevel.playSound(null, pPos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
        }
    }

    public void onSetColor(Level pLevel, BlockPos pPos, PaintColor color) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof HouseNumberSignBlockEntity) {
            HouseNumberSignBlockEntity blockEntity2 = (HouseNumberSignBlockEntity)blockEntity;
            if (!pLevel.isClientSide) {
                blockEntity2.setColor(color);
                pLevel.playSound(null, pPos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 0.8f, 2.0f);
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new HouseNumberSignBlockEntity(pPos, pState);
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.getOpposite() == pState.getValue((Property)FACING) && !pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos below = pPos.below();
        return pLevel.getBlockState(below).isFaceSturdy((BlockGetter)pLevel, below, Direction.UP);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate;
        if (!pContext.replacingClickedOnBlock() && (blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(pContext.getClickedFace().getOpposite()))).is((Block)this) && blockstate.getValue((Property)FACING) == pContext.getClickedFace()) {
            return null;
        }
        BlockState blockstate1 = this.defaultBlockState();
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        for (Direction direction : pContext.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockstate1 = (BlockState)blockstate1.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate1.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }
}

