/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import com.mojang.serialization.MapCodec;
import de.mrjulsen.trafficcraft.block.data.ColorableBlock;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConcreteBarrierBlock
extends ColorableBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<ConcreteBarrierBlock> CODEC = ConcreteBarrierBlock.simpleCodec(ConcreteBarrierBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_52346_ -> ((Direction)p_52346_.getKey()).getAxis().isHorizontal()).collect(Util.toMap());
    private static final VoxelShape SHAPE_SIDE_EAST = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), Block.box((double)8.0, (double)4.0, (double)3.5, (double)16.0, (double)7.0, (double)12.5), Block.box((double)8.0, (double)7.0, (double)4.75, (double)16.0, (double)10.0, (double)11.25)});
    private static final VoxelShape SHAPE_SIDE_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)3.0, (double)8.0, (double)4.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)10.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0), Block.box((double)0.0, (double)4.0, (double)3.5, (double)8.0, (double)7.0, (double)12.5), Block.box((double)0.0, (double)7.0, (double)4.75, (double)8.0, (double)10.0, (double)11.25)});
    private static final VoxelShape SHAPE_SIDE_SOUTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)8.0, (double)13.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)10.0, (double)8.0, (double)10.0, (double)16.0, (double)16.0), Block.box((double)3.5, (double)4.0, (double)8.0, (double)12.5, (double)7.0, (double)16.0), Block.box((double)4.75, (double)7.0, (double)8.0, (double)11.25, (double)10.0, (double)16.0)});
    private static final VoxelShape SHAPE_SIDE_NORTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)4.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)10.0, (double)0.0, (double)10.0, (double)16.0, (double)8.0), Block.box((double)3.5, (double)4.0, (double)0.0, (double)12.5, (double)7.0, (double)8.0), Block.box((double)4.75, (double)7.0, (double)0.0, (double)11.25, (double)10.0, (double)8.0)});
    private static final VoxelShape SHAPE_BASE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private static final VoxelShape COLLISION_EAST = Shapes.or((VoxelShape)Block.box((double)8.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)13.0), (VoxelShape)Block.box((double)8.0, (double)4.0, (double)4.75, (double)16.0, (double)24.0, (double)11.25));
    private static final VoxelShape COLLISION_WEST = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)3.0, (double)8.0, (double)4.0, (double)13.0), (VoxelShape)Block.box((double)0.0, (double)4.0, (double)4.75, (double)8.0, (double)24.0, (double)11.25));
    private static final VoxelShape COLLISION_SOUTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)8.0, (double)13.0, (double)4.0, (double)16.0), (VoxelShape)Block.box((double)4.75, (double)4.0, (double)8.0, (double)11.25, (double)24.0, (double)16.0));
    private static final VoxelShape COLLISION_NORTH = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)4.0, (double)8.0), (VoxelShape)Block.box((double)4.75, (double)4.0, (double)0.0, (double)11.25, (double)24.0, (double)8.0));
    private static final VoxelShape COLLISION_BASE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0));

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ConcreteBarrierBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.STONE).strength(3.0f).sound(SoundType.STONE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!(pState.getValue((Property)FACING) != Direction.NORTH && pState.getValue((Property)FACING) != Direction.SOUTH || ((Boolean)pState.getValue((Property)NORTH)).booleanValue() || ((Boolean)pState.getValue((Property)SOUTH)).booleanValue())) {
            return Shapes.or((VoxelShape)SHAPE_SIDE_EAST, (VoxelShape)SHAPE_SIDE_WEST);
        }
        if (!(pState.getValue((Property)FACING) != Direction.EAST && pState.getValue((Property)FACING) != Direction.WEST || ((Boolean)pState.getValue((Property)EAST)).booleanValue() || ((Boolean)pState.getValue((Property)WEST)).booleanValue())) {
            return Shapes.or((VoxelShape)SHAPE_SIDE_NORTH, (VoxelShape)SHAPE_SIDE_SOUTH);
        }
        VoxelShape shape = SHAPE_BASE;
        if (((Boolean)pState.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SIDE_NORTH);
        }
        if (((Boolean)pState.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SIDE_SOUTH);
        }
        if (((Boolean)pState.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SIDE_EAST);
        }
        if (((Boolean)pState.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SIDE_WEST);
        }
        return shape;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!(pState.getValue((Property)FACING) != Direction.NORTH && pState.getValue((Property)FACING) != Direction.SOUTH || ((Boolean)pState.getValue((Property)NORTH)).booleanValue() || ((Boolean)pState.getValue((Property)SOUTH)).booleanValue())) {
            return Shapes.or((VoxelShape)COLLISION_EAST, (VoxelShape)COLLISION_WEST);
        }
        if (!(pState.getValue((Property)FACING) != Direction.EAST && pState.getValue((Property)FACING) != Direction.WEST || ((Boolean)pState.getValue((Property)EAST)).booleanValue() || ((Boolean)pState.getValue((Property)WEST)).booleanValue())) {
            return Shapes.or((VoxelShape)COLLISION_NORTH, (VoxelShape)COLLISION_SOUTH);
        }
        VoxelShape shape = COLLISION_BASE;
        if (((Boolean)pState.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)COLLISION_NORTH);
        }
        if (((Boolean)pState.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)COLLISION_SOUTH);
        }
        if (((Boolean)pState.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)COLLISION_EAST);
        }
        if (((Boolean)pState.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)COLLISION_WEST);
        }
        return shape;
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public boolean connectsTo(BlockState pState, boolean pIsSideSolid, Direction pDirection) {
        boolean flag = this.isSameBlock(pState);
        return !ConcreteBarrierBlock.isExceptionForConnection((BlockState)pState) && pIsSideSolid || flag;
    }

    private boolean isSameBlock(BlockState pState) {
        return pState.is((Block)this);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level blockgetter = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockPos blockpos1 = blockpos.north();
        BlockPos blockpos2 = blockpos.east();
        BlockPos blockpos3 = blockpos.south();
        BlockPos blockpos4 = blockpos.west();
        BlockState blockstate = blockgetter.getBlockState(blockpos1);
        BlockState blockstate1 = blockgetter.getBlockState(blockpos2);
        BlockState blockstate2 = blockgetter.getBlockState(blockpos3);
        BlockState blockstate3 = blockgetter.getBlockState(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(pContext).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate, blockstate.isFaceSturdy((BlockGetter)blockgetter, blockpos1, Direction.SOUTH), Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate1, blockstate1.isFaceSturdy((BlockGetter)blockgetter, blockpos2, Direction.WEST), Direction.WEST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.connectsTo(blockstate2, blockstate2.isFaceSturdy((BlockGetter)blockgetter, blockpos3, Direction.NORTH), Direction.NORTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.connectsTo(blockstate3, blockstate3.isFaceSturdy((BlockGetter)blockgetter, blockpos4, Direction.EAST), Direction.EAST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return pFacing.getAxis().getPlane() == Direction.Plane.HORIZONTAL ? (BlockState)pState.setValue((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(this.connectsTo(pFacingState, pFacingState.isFaceSturdy((BlockGetter)pLevel, pFacingPos, pFacing.getOpposite()), pFacing.getOpposite()))) : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{NORTH, EAST, WEST, SOUTH, FACING, WATERLOGGED});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public int getDefaultColor() {
        return -5526613;
    }
}

