/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.trafficcraft.block;

import de.mrjulsen.trafficcraft.block.AsphaltBlock;
import de.mrjulsen.trafficcraft.block.PaintedAsphaltSlope;
import de.mrjulsen.trafficcraft.block.data.RoadType;
import de.mrjulsen.trafficcraft.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AsphaltSlope
extends AsphaltBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_HEIGHT = 8;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.empty(), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final int HEIGHT_IMPASSABLE = 5;

    public AsphaltSlope(RoadType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        switch (pathComputationType) {
            case LAND: {
                return (Integer)state.getValue((Property)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack tool) {
        if (!tool.is((Item)ModItems.HAMMER.get())) {
            super.playerDestroy(level, player, pos, state, blockEntity, tool);
            return;
        }
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
        if (level.isClientSide) {
            level.levelEvent(player, 2001, pos, Block.getId((BlockState)state));
        } else {
            if (!player.isCreative() && !player.isSpectator()) {
                AsphaltSlope.dropResources((BlockState)state.getBlock().defaultBlockState(), (Level)level, (BlockPos)pos.offset(0, (int)(0.125f * (float)((Integer)state.getValue((Property)BlockStateProperties.LAYERS) + 1)), 0));
            }
            tool.hurtAndBreak(1, (ServerLevel)level, (ServerPlayer)player, item -> player.onEquippedItemBroken(item, player.getItemInHand(InteractionHand.MAIN_HAND) == tool ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
        }
        if ((Integer)state.getValue((Property)BlockStateProperties.LAYERS) <= 1) {
            return;
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)BlockStateProperties.LAYERS) - 1)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public VoxelShape getVisualShape(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_LAYER[(Integer)pState.getValue((Property)LAYERS)];
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        int i = (Integer)pState.getValue((Property)LAYERS);
        Item item = pUseContext.getItemInHand().getItem();
        if (item instanceof BlockItem) {
            Block block;
            BlockItem blockitem = (BlockItem)item;
            if (i < 8 && (block = blockitem.getBlock()) instanceof AsphaltSlope) {
                AsphaltSlope selectedSlope = (AsphaltSlope)block;
                block = pState.getBlock();
                if (block instanceof AsphaltSlope) {
                    AsphaltSlope targetSlope = (AsphaltSlope)block;
                    if (selectedSlope.getDefaultRoadType() == targetSlope.getDefaultRoadType()) {
                        if (pUseContext.replacingClickedOnBlock()) {
                            return pUseContext.getClickedFace() == Direction.UP;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean flag;
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos());
        FluidState fluidstate = pContext.getLevel().getFluidState(pContext.getClickedPos());
        boolean bl = flag = fluidstate.getType() == Fluids.WATER;
        if (blockstate.getBlock() instanceof PaintedAsphaltSlope || blockstate.getBlock() instanceof AsphaltSlope) {
            int i = (Integer)blockstate.getValue((Property)LAYERS);
            return (BlockState)((BlockState)blockstate.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return (BlockState)super.getStateForPlacement(pContext).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LAYERS, WATERLOGGED});
        super.createBlockStateDefinition(pBuilder);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }
}

