/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.util;

import com.li64.tide.client.TideClientHelper;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.registries.TideItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTideFish
extends AbstractSchoolingFish {
    public AbstractTideFish(EntityType<? extends AbstractSchoolingFish> entityType, Level level) {
        super(entityType, level);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.MOVEMENT_SPEED, 1.0);
    }

    @NotNull
    protected SoundEvent getFlopSound() {
        return SoundEvents.COD_FLOP;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        return SoundEvents.COD_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.COD_DEATH;
    }

    public boolean hasCustomName() {
        return !TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.getFishItem());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).is(TideItems.FISHING_JOURNAL)) {
            if (this.level().isClientSide()) {
                TideClientHelper.openJournalScreen(this.getFishItem());
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public Component getCustomName() {
        if (TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.getFishItem())) {
            return super.getCustomName();
        }
        return this.getName();
    }

    protected Component getTypeName() {
        return this.getFishItem().getDescription();
    }

    public Component getName() {
        if (!TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.getFishItem())) {
            return Component.literal((String)"???");
        }
        return super.getName();
    }

    public abstract Item getFishItem();

    public static boolean canSpawn(EntityType<? extends AbstractTideFish> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WaterAnimal.checkSurfaceWaterAnimalSpawnRules(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

