/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.renderers;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.models.SimpleFishModel;
import com.li64.tide.registries.entities.util.AbstractTideFish;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SimpleFishRenderer<T extends AbstractTideFish>
extends MobRenderer<T, SimpleFishModel<T>> {
    private final ResourceLocation texLocation;

    public SimpleFishRenderer(String name, SimpleFishModel.Variant variant, EntityRendererProvider.Context context) {
        super(context, new SimpleFishModel(context.bakeLayer(variant.modelLocation())), 0.3f);
        this.texLocation = Tide.resource("textures/entity/fish/" + name + ".png");
    }

    public ResourceLocation getTextureLocation(T fish) {
        return this.texLocation;
    }

    protected void setupRotations(T fish, PoseStack poseStack, float rx, float ry, float rz, float idk) {
        super.setupRotations(fish, poseStack, rx, ry, rz, idk);
        float f = 4.3f * Mth.sin((float)(0.6f * rx));
        poseStack.mulPose(Axis.YP.rotationDegrees(f));
        if (!fish.isInWater()) {
            poseStack.translate(0.1f, 0.1f, -0.1f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

