/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.models;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.util.AbstractTideFish;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SimpleFishModel<T extends AbstractTideFish>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart tail;

    public SimpleFishModel(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer(Variant variant) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(11, 0).addBox(-1.0f, -5.0f, -4.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -4.0f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        switch (variant.ordinal()) {
            case 0: {
                body.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-4.0f));
                break;
            }
            case 1: {
                body.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 3).addBox(-1.0f, -5.0f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                break;
            }
            case 2: {
                body.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(18, 6).addBox(-1.0f, -4.0f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
                break;
            }
            case 3: {
                body.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(19, 0).addBox(-1.0f, -5.0f, -5.0f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
            }
        }
        body.addOrReplaceChild("fin_right", CubeListBuilder.create().texOffs(0, 5).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)1.0f, (float)3.1416f, (float)0.0f, (float)0.6981f));
        body.addOrReplaceChild("fin_left", CubeListBuilder.create().texOffs(0, 7).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)2.4435f));
        body.addOrReplaceChild("fin_top", CubeListBuilder.create().texOffs(0, 3).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)1.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 13).addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        if (!entity.isInWater()) {
            f = 1.5f;
        }
        this.tail.yRot = -f * 0.45f * Mth.sin((float)(0.6f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public static enum Variant {
        NOSE_NORMAL("normal"),
        NOSE_UPPER("upper"),
        NOSE_LOWER("lower"),
        NOSE_FULL("full");

        private final ModelLayerLocation modelLocation;

        private Variant(String name) {
            this.modelLocation = new ModelLayerLocation(Tide.resource("simple_fish/nose_" + name), "main");
        }

        public ModelLayerLocation modelLocation() {
            return this.modelLocation;
        }
    }
}

