/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.models;

import com.li64.tide.Tide;
import com.li64.tide.registries.entities.fish.Barracuda;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BarracudaModel<T extends Barracuda>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Tide.resource("barracuda"), "main");
    private final ModelPart body;
    private final ModelPart back;
    private final ModelPart tail;

    public BarracudaModel(ModelPart root) {
        this.body = root.getChild("body");
        this.back = this.body.getChild("back");
        this.tail = this.back.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)1.0f));
        PartDefinition front = body.addOrReplaceChild("front", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -11.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-1.0f, -1.0f, -13.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(13, 0).addBox(-1.0f, -2.0f, -12.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-1.0f, 1.0f, -13.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-1.0f, -2.0f, -9.0f, 2.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)3.0f));
        front.addOrReplaceChild("fin_top", CubeListBuilder.create().texOffs(0, 17).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(12, 12).addBox(0.0f, 4.0f, -1.0f, 0.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-2.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        front.addOrReplaceChild("fin_right", CubeListBuilder.create().texOffs(12, 8).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-5.0f, (float)3.1416f, (float)0.0f, (float)0.6981f));
        front.addOrReplaceChild("fin_left", CubeListBuilder.create().texOffs(12, 10).addBox(0.0f, -2.0f, -4.0f, 0.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)2.4435f));
        PartDefinition back = body.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)3.0f));
        back.addOrReplaceChild("fin_bottom", CubeListBuilder.create().texOffs(12, 6).addBox(0.0f, -2.0f, -1.0f, 0.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(12, 4).addBox(0.0f, -8.0f, -1.0f, 0.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)7.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition tail = back.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)8.0f));
        tail.addOrReplaceChild("tail_1", CubeListBuilder.create().texOffs(16, 19).addBox(0.0f, -3.0f, -6.0f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = 1.0f;
        float f1 = 1.0f;
        if (!entity.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        this.back.yRot = -f * 0.2f * Mth.sin((float)(f1 * 0.6f * ageInTicks));
        this.tail.yRot = -f * 0.15f * Mth.sin((float)(f1 * 0.6f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

