/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.registries.entities.misc;

import com.li64.tide.Tide;
import com.li64.tide.registries.TideBlocks;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.blocks.entities.LootCrateBlockEntity;
import java.util.function.Predicate;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LootCrateEntity
extends Entity {
    private ResourceKey<LootTable> lootTable;
    private LootParams lootParams;
    private BlockState blockState = TideBlocks.SURFACE_LOOT_CRATE.defaultBlockState();
    public int time;
    public boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    public CompoundTag blockData;
    public boolean forceTickAfterTeleportToDuplicate;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.defineId(LootCrateEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public LootCrateEntity(EntityType<? extends Entity> p_31950_, Level p_31951_) {
        super(p_31950_, p_31951_);
    }

    private LootCrateEntity(Level level, double x, double y, double z, BlockState blockState, ResourceKey<LootTable> lootTable, LootParams lootParams) {
        this(TideEntityTypes.LOOT_CRATE, level);
        this.blockState = blockState;
        this.blocksBuilding = true;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setStartPos(this.blockPosition());
        this.lootTable = lootTable;
        this.lootParams = lootParams;
    }

    public static LootCrateEntity fall(Level level, BlockPos pos, BlockState state, double dx, double dy, double dz, ResourceKey<LootTable> lootTable, LootParams lootParams) {
        LootCrateEntity entity = new LootCrateEntity(level, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, state, lootTable, lootParams);
        entity.setDeltaMovement(dx, dy, dz);
        level.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
        level.addFreshEntity((Entity)entity);
        return entity;
    }

    public boolean isAttackable() {
        return false;
    }

    public void setStartPos(BlockPos p_31960_) {
        this.entityData.set(DATA_START_POS, (Object)p_31960_);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.entityData.get(DATA_START_POS);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_329911_) {
        p_329911_.define(DATA_START_POS, (Object)BlockPos.ZERO);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void tick() {
        if (this.blockState.isAir()) {
            this.discard();
        } else {
            Block block = this.blockState.getBlock();
            ++this.time;
            this.applyGravity();
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.handlePortal();
            if (!this.level().isClientSide && (this.isAlive() || this.forceTickAfterTeleportToDuplicate)) {
                BlockHitResult blockhitresult;
                BlockPos blockpos = this.blockPosition();
                boolean flag = this.blockState.getBlock() instanceof ConcretePowderBlock;
                boolean flag1 = flag && this.level().getFluidState(blockpos).is(FluidTags.WATER);
                double d0 = this.getDeltaMovement().lengthSqr();
                if (flag && d0 > 1.0 && (blockhitresult = this.level().clip(new ClipContext(new Vec3(this.xo, this.yo, this.zo), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).getType() != HitResult.Type.MISS && this.level().getFluidState(blockpos).is(FluidTags.WATER)) {
                    blockpos = blockhitresult.getBlockPos();
                    flag1 = true;
                }
                if (this.onGround() || flag1) {
                    BlockState placeBlockState = this.level().getBlockState(blockpos);
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
                    if (!placeBlockState.is(Blocks.MOVING_PISTON)) {
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag2 = placeBlockState.canBeReplaced((BlockPlaceContext)new DirectionalPlaceContext(this.level(), blockpos, Direction.DOWN, ItemStack.EMPTY, Direction.UP));
                            boolean flag3 = FallingBlock.isFree((BlockState)this.level().getBlockState(blockpos.below())) && (!flag || !flag1);
                            boolean bl = flag4 = this.blockState.canSurvive((LevelReader)this.level(), blockpos) && !flag3;
                            if (flag2 && flag4) {
                                if (this.blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && this.level().getFluidState(blockpos).getType() == Fluids.WATER) {
                                    this.blockState = (BlockState)this.blockState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.level().setBlock(blockpos, this.blockState, 3)) {
                                    ((ServerLevel)this.level()).getChunkSource().chunkMap.broadcast((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.level().getBlockState(blockpos)));
                                    this.discard();
                                    Tide.LOG.debug("Blockdata == null: {}", (Object)(this.blockData == null ? 1 : 0));
                                    Tide.LOG.debug("HasBlockEntity: {}", (Object)this.blockState.hasBlockEntity());
                                    if (this.blockState.hasBlockEntity()) {
                                        Tide.LOG.debug("Loading block entity");
                                        BlockEntity blockEntity = this.level().getBlockEntity(blockpos);
                                        if (blockEntity != null && blockEntity instanceof LootCrateBlockEntity) {
                                            LootCrateBlockEntity lootCrateBlockEntity = (LootCrateBlockEntity)blockEntity;
                                            Tide.LOG.debug("Adding crate loot to entity");
                                            this.addCrateLoot(lootCrateBlockEntity);
                                        }
                                    }
                                } else if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.discard();
                                    this.spawnAtLocation((ItemLike)block);
                                    this.dropCrateLoot();
                                }
                            } else {
                                this.discard();
                                if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                                    this.spawnAtLocation((ItemLike)block);
                                    this.dropCrateLoot();
                                }
                            }
                        } else {
                            this.discard();
                        }
                    }
                } else if (!(this.level().isClientSide || (this.time <= 100 || blockpos.getY() > this.level().getMinBuildHeight() && blockpos.getY() <= this.level().getMaxBuildHeight()) && this.time <= 600)) {
                    if (this.dropItem && this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                        this.spawnAtLocation((ItemLike)block);
                        this.dropCrateLoot();
                    }
                    this.discard();
                }
            }
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
    }

    public boolean causeFallDamage(float p_149643_, float p_149644_, DamageSource p_149645_) {
        DamageSource damageSource;
        if (!this.hurtEntities) {
            return false;
        }
        int i = Mth.ceil((float)(p_149643_ - 1.0f));
        if (i < 0) {
            return false;
        }
        Predicate predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        Block block = this.blockState.getBlock();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)block;
            damageSource = fallable.getFallDamageSource((Entity)this);
        } else {
            damageSource = this.damageSources().fallingBlock((Entity)this);
        }
        DamageSource damagesource = damageSource;
        float f = Math.min(Mth.floor((float)((float)i * this.fallDamagePerDistance)), this.fallDamageMax);
        this.level().getEntities((Entity)this, this.getBoundingBox(), predicate).forEach(p_149649_ -> p_149649_.hurt(damagesource, f));
        boolean flag = this.blockState.is(BlockTags.ANVIL);
        if (flag && f > 0.0f && this.random.nextFloat() < 0.05f + (float)i * 0.05f) {
            BlockState blockstate = AnvilBlock.damage((BlockState)this.blockState);
            if (blockstate == null) {
                this.cancelDrop = true;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    protected void addAdditionalSaveData(CompoundTag p_31973_) {
        p_31973_.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.blockState));
        p_31973_.putInt("Time", this.time);
        p_31973_.putBoolean("DropItem", this.dropItem);
        p_31973_.putBoolean("HurtEntities", this.hurtEntities);
        p_31973_.putFloat("FallHurtAmount", this.fallDamagePerDistance);
        p_31973_.putInt("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            p_31973_.put("TileEntityData", (Tag)this.blockData);
        }
        p_31973_.putBoolean("CancelDrop", this.cancelDrop);
    }

    protected void readAdditionalSaveData(CompoundTag p_31964_) {
        this.blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)p_31964_.getCompound("BlockState"));
        this.time = p_31964_.getInt("Time");
        if (p_31964_.contains("HurtEntities", 99)) {
            this.hurtEntities = p_31964_.getBoolean("HurtEntities");
            this.fallDamagePerDistance = p_31964_.getFloat("FallHurtAmount");
            this.fallDamageMax = p_31964_.getInt("FallHurtMax");
        } else if (this.blockState.is(BlockTags.ANVIL)) {
            this.hurtEntities = true;
        }
        if (p_31964_.contains("DropItem", 99)) {
            this.dropItem = p_31964_.getBoolean("DropItem");
        }
        if (p_31964_.contains("TileEntityData", 10)) {
            this.blockData = p_31964_.getCompound("TileEntityData").copy();
        }
        this.cancelDrop = p_31964_.getBoolean("CancelDrop");
        if (this.blockState.isAir()) {
            this.blockState = Blocks.SAND.defaultBlockState();
        }
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public void fillCrashReportCategory(CrashReportCategory p_31962_) {
        super.fillCrashReportCategory(p_31962_);
        p_31962_.setDetail("Immitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    protected Component getTypeName() {
        return Component.translatable((String)"entity.minecraft.falling_block_type", (Object[])new Object[]{this.blockState.getBlock().getName()});
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_342166_) {
        return new ClientboundAddEntityPacket((Entity)this, p_342166_, Block.getId((BlockState)this.getBlockState()));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_149654_) {
        super.recreateFromPacket(p_149654_);
        this.blockState = Block.stateById((int)p_149654_.getData());
        this.blocksBuilding = true;
        double d0 = p_149654_.getX();
        double d1 = p_149654_.getY();
        double d2 = p_149654_.getZ();
        this.setPos(d0, d1, d2);
        this.setStartPos(this.blockPosition());
    }

    public Entity changeDimension(DimensionTransition dimensionTransition) {
        ResourceKey newDimension = dimensionTransition.newLevel().dimension();
        ResourceKey oldDimension = this.level().dimension();
        boolean flag = (oldDimension == Level.END || newDimension == Level.END) && oldDimension != newDimension;
        Entity entity = super.changeDimension(dimensionTransition);
        this.forceTickAfterTeleportToDuplicate = entity != null && flag;
        return entity;
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    public void dropCrateLoot() {
        if (this.lootTable != null && this.level().getServer() != null) {
            LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(this.lootTable);
            lootTable.getRandomItems(this.lootParams).forEach(arg_0 -> ((LootCrateEntity)this).spawnAtLocation(arg_0));
        }
    }

    public void addCrateLoot(LootCrateBlockEntity block) {
        if (this.lootTable != null && this.level().getServer() != null) {
            LootTable lootTable = this.level().getServer().reloadableRegistries().getLootTable(this.lootTable);
            lootTable.fill((Container)block, this.lootParams, this.random.nextLong());
        }
    }
}

