/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data.journal.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.li64.tide.Tide;
import com.li64.tide.data.journal.JournalLayout;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class JournalPageCustomData
extends SimpleJsonResourceReloadListener {
    public static final String DATA_PATH = "journal/pages";
    private static final Gson GSON = new Gson();

    public JournalPageCustomData() {
        super(GSON, DATA_PATH);
    }

    @NotNull
    public String getName() {
        return "Tide Journal Page Data Loader";
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        ArrayList output = new ArrayList();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation entryKey = entry.getKey();
            try {
                JournalLayout.Page.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).result().ifPresentOrElse(output::add, () -> Tide.LOG.warn("Did not load invalid profile entry {}", (Object)entryKey));
            }
            catch (JsonParseException | IllegalArgumentException parseException) {
                Tide.LOG.error("Parsing error loading custom journal page {}", (Object)entryKey, (Object)parseException);
            }
        }
        ImmutableList pages = ImmutableList.copyOf(output);
        Tide.LOG.info("Loaded {} custom journal pages", (Object)pages.size());
        Tide.JOURNAL.addPageConfigs((List<JournalLayout.Page>)pages);
    }
}

