/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.data;

import com.li64.tide.Tide;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class TideLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();

    private static ResourceKey<LootTable> biome(String biome) {
        return TideLootTables.create("gameplay/fishing/biomes/" + biome);
    }

    private static ResourceKey<LootTable> create(String path) {
        return TideLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Tide.resource(path)));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> lootTableKey) {
        LOCATIONS.add(lootTableKey);
        return lootTableKey;
    }

    public static ResourceKey<LootTable> getByLocation(ResourceLocation location) {
        return LOCATIONS.stream().filter(resourceKey -> resourceKey.location().equals((Object)location)).findFirst().orElse(null);
    }

    public static class Modded {
        public static final ResourceKey<LootTable> EVERBRIGHT = TideLootTables.create("gameplay/fishing/climates/blue_skies/everbright");
        public static final ResourceKey<LootTable> EVERDAWN = TideLootTables.create("gameplay/fishing/climates/blue_skies/everdawn");
    }

    public static class Blocks {
        public static final ResourceKey<LootTable> ALGAE = TideLootTables.create("blocks/algae");
        public static final ResourceKey<LootTable> ANGLER_WORKSHOP = TideLootTables.create("blocks/angler_workshop");
        public static final ResourceKey<LootTable> JELLY_TORCH = TideLootTables.create("blocks/jelly_torch");
        public static final ResourceKey<LootTable> SURFACE_LOOT_CRATE = TideLootTables.create("blocks/surface_loot_crate");
        public static final ResourceKey<LootTable> OBSIDIAN_LOOT_CRATE = TideLootTables.create("blocks/obsidian_loot_crate");
        public static final ResourceKey<LootTable> END_LOOT_CRATE = TideLootTables.create("blocks/end_loot_crate");
    }

    public static class Entities {
        public static final ResourceKey<LootTable> TROUT = TideLootTables.create("entities/trout");
        public static final ResourceKey<LootTable> BASS = TideLootTables.create("entities/bass");
        public static final ResourceKey<LootTable> YELLOW_PERCH = TideLootTables.create("entities/yellow_perch");
        public static final ResourceKey<LootTable> BLUEGILL = TideLootTables.create("entities/bluegill");
        public static final ResourceKey<LootTable> MINT_CARP = TideLootTables.create("entities/mint_carp");
        public static final ResourceKey<LootTable> PIKE = TideLootTables.create("entities/pike");
        public static final ResourceKey<LootTable> GUPPY = TideLootTables.create("entities/guppy");
        public static final ResourceKey<LootTable> CATFISH = TideLootTables.create("entities/catfish");
        public static final ResourceKey<LootTable> CLAYFISH = TideLootTables.create("entities/clayfish");
        public static final ResourceKey<LootTable> TUNA = TideLootTables.create("entities/tuna");
        public static final ResourceKey<LootTable> OCEAN_PERCH = TideLootTables.create("entities/ocean_perch");
        public static final ResourceKey<LootTable> MACKEREL = TideLootTables.create("entities/mackerel");
        public static final ResourceKey<LootTable> ANGELFISH = TideLootTables.create("entities/angelfish");
        public static final ResourceKey<LootTable> BARRACUDA = TideLootTables.create("entities/barracuda");
        public static final ResourceKey<LootTable> SAILFISH = TideLootTables.create("entities/sailfish");
    }

    public static class Biomes {
        public static final ResourceKey<LootTable> BADLANDS = TideLootTables.biome("badlands");
        public static final ResourceKey<LootTable> BIRCH = TideLootTables.biome("birch");
        public static final ResourceKey<LootTable> CHERRY = TideLootTables.biome("cherry");
        public static final ResourceKey<LootTable> DEEP_DARK = TideLootTables.biome("deep_dark");
        public static final ResourceKey<LootTable> DESERT = TideLootTables.biome("desert");
        public static final ResourceKey<LootTable> DRIPSTONE = TideLootTables.biome("dripstone");
        public static final ResourceKey<LootTable> FOREST = TideLootTables.biome("forest");
        public static final ResourceKey<LootTable> FROZEN = TideLootTables.biome("frozen");
        public static final ResourceKey<LootTable> JUNGLE = TideLootTables.biome("jungle");
        public static final ResourceKey<LootTable> LUSH_CAVES = TideLootTables.biome("lush_caves");
        public static final ResourceKey<LootTable> MOUNTAIN = TideLootTables.biome("mountain");
        public static final ResourceKey<LootTable> MUSHROOM = TideLootTables.biome("mushroom");
        public static final ResourceKey<LootTable> PLAINS = TideLootTables.biome("plains");
        public static final ResourceKey<LootTable> SAVANNA = TideLootTables.biome("savanna");
        public static final ResourceKey<LootTable> SWAMP = TideLootTables.biome("swamp");
        public static final ResourceKey<LootTable> TAIGA = TideLootTables.biome("taiga");
    }

    public static class Chests {
        public static final ResourceKey<LootTable> FISHING_BOAT = TideLootTables.create("chests/fishing_boat");
    }

    public static class Crates {
        public static final ResourceKey<LootTable> OVERWORLD_LAVA_SURFACE = TideLootTables.create("gameplay/fishing/crates/overworld/lava_surface");
        public static final ResourceKey<LootTable> OVERWORLD_LAVA_UNDERGROUND = TideLootTables.create("gameplay/fishing/crates/overworld/lava_underground");
        public static final ResourceKey<LootTable> OVERWORLD_LAVA_DEEP = TideLootTables.create("gameplay/fishing/crates/overworld/lava_deep");
        public static final ResourceKey<LootTable> OVERWORLD_WATER_OCEAN = TideLootTables.create("gameplay/fishing/crates/overworld/water_ocean");
        public static final ResourceKey<LootTable> OVERWORLD_WATER_RIVER = TideLootTables.create("gameplay/fishing/crates/overworld/water_river");
        public static final ResourceKey<LootTable> OVERWORLD_WATER_UNDERGROUND = TideLootTables.create("gameplay/fishing/crates/overworld/water_underground");
        public static final ResourceKey<LootTable> OVERWORLD_WATER_DEEP = TideLootTables.create("gameplay/fishing/crates/overworld/water_deep");
        public static final ResourceKey<LootTable> NETHER_LAVA = TideLootTables.create("gameplay/fishing/crates/nether/lava");
        public static final ResourceKey<LootTable> END_WATER = TideLootTables.create("gameplay/fishing/crates/end/water");
        public static final ResourceKey<LootTable> END_LAVA = TideLootTables.create("gameplay/fishing/crates/end/lava");
    }

    public static class Fishing {
        public static final ResourceKey<LootTable> FRESHWATER_NORMAL = TideLootTables.create("gameplay/fishing/climates/freshwater_normal");
        public static final ResourceKey<LootTable> FRESHWATER_COLD = TideLootTables.create("gameplay/fishing/climates/freshwater_cold");
        public static final ResourceKey<LootTable> FRESHWATER_WARM = TideLootTables.create("gameplay/fishing/climates/freshwater_warm");
        public static final ResourceKey<LootTable> SALTWATER_NORMAL = TideLootTables.create("gameplay/fishing/climates/saltwater_normal");
        public static final ResourceKey<LootTable> SALTWATER_COLD = TideLootTables.create("gameplay/fishing/climates/saltwater_cold");
        public static final ResourceKey<LootTable> SALTWATER_WARM = TideLootTables.create("gameplay/fishing/climates/saltwater_warm");
        public static final ResourceKey<LootTable> LAVA_SURFACE = TideLootTables.create("gameplay/fishing/climates/lava_surface");
        public static final ResourceKey<LootTable> UNDERGROUND = TideLootTables.create("gameplay/fishing/climates/underground");
        public static final ResourceKey<LootTable> LAVA_UNDERGROUND = TideLootTables.create("gameplay/fishing/climates/lava_underground");
        public static final ResourceKey<LootTable> DEPTHS = TideLootTables.create("gameplay/fishing/climates/depths");
        public static final ResourceKey<LootTable> LAVA_DEPTHS = TideLootTables.create("gameplay/fishing/climates/lava_depths");
        public static final ResourceKey<LootTable> NETHER = TideLootTables.create("gameplay/fishing/climates/nether");
        public static final ResourceKey<LootTable> END_WATER = TideLootTables.create("gameplay/fishing/climates/end_water");
        public static final ResourceKey<LootTable> END_LAVA = TideLootTables.create("gameplay/fishing/climates/end_lava");
    }
}

