/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.compat.jei.recipe;

import com.li64.tide.data.TideTags;
import com.li64.tide.data.rods.CustomRodManager;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RodUpgradingRecipe
implements Recipe<RecipeInput> {
    private final ItemStack input;
    private final ItemStack output;

    public RodUpgradingRecipe(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean matches(RecipeInput input, Level level) {
        return !level.isClientSide;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_331967_) {
        ItemStack newRod = this.output.copy();
        CustomRodManager.setBobber(newRod, new Random().nextInt(0, 16));
        CustomRodManager.setHook(newRod, new Random().nextInt(0, 3));
        CustomRodManager.setLine(newRod, new Random().nextInt(0, 4));
        return newRod;
    }

    public RecipeSerializer<RodUpgradingRecipe> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<RodUpgradingRecipe> getType() {
        return Type.INSTANCE;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public Ingredient getModifier(int modifier) {
        return switch (modifier) {
            case 0 -> Ingredient.of(TideTags.Items.LINES);
            case 1 -> Ingredient.of(TideTags.Items.BOBBERS);
            default -> Ingredient.of(TideTags.Items.HOOKS);
        };
    }

    public static class Serializer
    implements RecipeSerializer<RodUpgradingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<RodUpgradingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.STRICT_CODEC.fieldOf("input").forGetter(recipe -> recipe.input), (App)ItemStack.STRICT_CODEC.fieldOf("output").forGetter(recipe -> recipe.output)).apply((Applicative)builder, RodUpgradingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RodUpgradingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static RodUpgradingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack input = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new RodUpgradingRecipe(input, output);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, RodUpgradingRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.getResultItem(null));
        }

        public MapCodec<RodUpgradingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RodUpgradingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }

    public static class Type
    implements RecipeType<RodUpgradingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "rod_upgrading";
    }
}

