/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide.client.gui.screens;

import com.li64.tide.Tide;
import com.li64.tide.client.gui.JournalPage;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.player.TidePlayerData;
import com.li64.tide.network.messages.ReadProfileMsg;
import com.li64.tide.registries.TideSoundEvents;
import com.li64.tide.util.TideUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FishingJournalScreen
extends Screen {
    private static final int SLOT_SIZE = 22;
    private static final int SLOT_MARGIN = 4;
    private static final ResourceLocation PROFILE_BG = Tide.resource("journal_profile");
    private int numRows;
    private int numCols;
    private int totalSlots;
    private ArrayList<JournalPage> pages;
    public ItemStack profileFish = null;
    public JournalLayout.Profile profileConfig = null;
    public int page;
    public Player player;

    public FishingJournalScreen(Player player) {
        super(GameNarrator.NO_TITLE);
        this.player = player;
        this.loadJournalPages();
        player.playSound(TideSoundEvents.JOURNAL_OPEN, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    private void loadJournalPages() {
        try {
            this.pages = new ArrayList();
            Tide.JOURNAL.getPageConfigs().stream().map(JournalPage::new).forEach(page -> this.pages.add((JournalPage)page));
        }
        catch (Exception e) {
            Tide.LOG.error("Exception in loading journal pages: {}, {}", (Object)e.getMessage(), (Object)e.getCause());
        }
        this.pages.removeIf(journalPage -> !TidePlayerData.CLIENT_DATA.hasPageUnlocked((JournalPage)journalPage));
    }

    private void nextPage(int page) {
        this.clearWidgets();
        this.page = page;
        this.totalSlots = this.getPage().getAllProfiles().size();
        this.numCols = this.calculateNumCols(this.totalSlots);
        this.numRows = this.calculateNumRows(this.totalSlots);
        this.init();
        this.player.playSound(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    protected void init() {
        this.clearWidgets();
        if (this.profileFish != null) {
            this.createProfileControls();
        } else {
            this.createMenuControls();
            this.createFishIcons();
        }
    }

    public void onClose() {
        super.onClose();
        this.player.playSound(TideSoundEvents.JOURNAL_CLOSE, 0.9f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    private void createFishIcons() {
        int startX = (this.width - this.getTotalWidth()) / 2;
        int startY = (this.height - this.getTotalHeight()) / 2;
        List<JournalLayout.Profile> profiles = this.getPage().getAllProfiles();
        for (int i = 0; i < this.totalSlots && i < profiles.size(); ++i) {
            int row = i / this.numCols;
            int col = i % this.numCols;
            int x = startX + col * 26;
            int y = startY + row * 26 - 26;
            JournalLayout.Profile profile = profiles.get(i);
            if (profile.getFish().isEmpty()) continue;
            this.addRenderableWidget((GuiEventListener)new FishButton(x, y, 22, 22, profile, this));
        }
    }

    private JournalPage getPage() {
        return this.pages.get(this.page);
    }

    private int calculateNumRows(int slots) {
        return Mth.ceil((float)((float)slots / (float)this.numCols));
    }

    private int calculateNumCols(int slots) {
        return Math.min(12, slots);
    }

    private int getTotalWidth() {
        return this.numCols * 26 - 4;
    }

    private int getTotalHeight() {
        return this.numRows * 26 - 4;
    }

    private void createMenuControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 80, this.height - 40, 160, 18).build());
        if (this.page > 0) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<<"), button -> this.pageLeft()).bounds(30, this.height - 40, 18, 18).build());
        }
        if (this.page < this.pages.size() - 1) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">>"), button -> this.pageRight()).bounds(this.width - 30, this.height - 40, 18, 18).build());
        }
    }

    private void createProfileControls() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, button -> this.closeProfile()).bounds(this.width / 2 - 80, this.height - 40, 160, 18).build());
    }

    private void closeProfile() {
        this.profileConfig = null;
        this.profileFish = null;
        this.init();
        this.player.playSound(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
    }

    public void pageLeft() {
        if (this.page > 0) {
            this.nextPage(this.page - 1);
        }
    }

    public void pageRight() {
        if (this.page < this.pages.size() - 1) {
            this.nextPage(this.page + 1);
        }
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        super.render(graphics, mouseX, mouseY, partialTick);
        if (this.profileFish == null) {
            MutableComponent title = Component.translatable((String)this.getPage().title());
            MutableComponent content = Component.translatable((String)this.getPage().content());
            List formattedContent = this.font.split((FormattedText)content, 300);
            int titleX = (this.width - this.font.width((FormattedText)title)) / 2;
            int titleY = 30;
            if (this.page == 0) {
                titleY = 70;
            }
            int contentX = (this.width - 300) / 2;
            int contentY = this.height - 90;
            if (this.page == 0) {
                contentY = this.height - 125;
            }
            graphics.drawString(this.font, title.getString(), titleX, titleY, 0xFFFFFF);
            for (int i = 0; i < formattedContent.size(); ++i) {
                graphics.drawString(this.font, (FormattedCharSequence)formattedContent.get(i), contentX, contentY + 10 * i, 0xFFFFFF);
            }
        } else {
            this.renderProfile(graphics);
        }
    }

    public void openProfile(JournalLayout.Profile profile) {
        this.profileConfig = profile;
        this.profileFish = ((Item)BuiltInRegistries.ITEM.get((ResourceLocation)ResourceLocation.read((String)profile.fishItem()).getOrThrow())).getDefaultInstance();
        this.player.playSound(TideSoundEvents.PAGE_FLIP, 1.0f, 1.0f + new Random().nextFloat() * 0.2f);
        Tide.NETWORK.sendToServer(new ReadProfileMsg(this.profileFish));
        this.init();
    }

    public void renderProfile(GuiGraphics graphics) {
        FormattedCharSequence charSequence;
        int i;
        int bgWidth = 291;
        int bgHeight = 202;
        int offsetY = 20;
        graphics.blitSprite(PROFILE_BG, (this.width - bgWidth) / 2, (this.height - bgHeight) / 2 - offsetY, bgWidth, bgHeight);
        Style underlined = Component.empty().getStyle().withUnderlined(Boolean.valueOf(true));
        MutableComponent descriptionRaw = Component.translatable((String)this.profileConfig.description());
        MutableComponent locationTitleRaw = Component.translatable((String)"profile.info.location").withStyle(underlined);
        MutableComponent locationRaw = Component.translatable((String)("profile.info.location." + this.profileConfig.location()));
        MutableComponent climateTitleRaw = Component.translatable((String)"profile.info.climate").withStyle(underlined);
        MutableComponent climateRaw = Component.translatable((String)("profile.info.climate." + this.profileConfig.climate()));
        List description = this.font.split((FormattedText)descriptionRaw, 114);
        ArrayList location = new ArrayList();
        location.addAll(this.font.split((FormattedText)locationTitleRaw, 114));
        location.addAll(this.font.split((FormattedText)locationRaw, 114));
        ArrayList climate = new ArrayList();
        climate.addAll(this.font.split((FormattedText)climateTitleRaw, 114));
        climate.addAll(this.font.split((FormattedText)climateRaw, 114));
        Component fishName = TideUtils.removeRawTextInName(this.profileFish.getHoverName());
        float scaleAmount = 2.0f;
        int titleX = (this.width - this.font.width((FormattedText)fishName) - bgWidth / 2) / 2;
        int imageX = (int)(((float)this.width - 16.0f * scaleAmount - (float)(bgWidth / 2)) / 2.0f);
        int leftContentX = (this.width - bgWidth / 2) / 2;
        int rightContentX = (this.width + bgWidth / 2) / 2;
        int rightTop = (this.height - 204) / 2 - 6;
        int leftTop = rightTop + (descriptionRaw.getString().isEmpty() ? 55 : 0);
        graphics.drawString(this.font, fishName, titleX, leftTop, 0, false);
        for (i = 0; i < description.size(); ++i) {
            graphics.drawString(this.font, (FormattedCharSequence)description.get(i), leftContentX - 56, leftTop + 46 + 11 * i, 0, false);
        }
        for (i = 0; i < location.size(); ++i) {
            charSequence = (FormattedCharSequence)location.get(i);
            graphics.drawString(this.font, charSequence, rightContentX - this.font.width(charSequence) / 2, rightTop + 46 + 11 * i, 0, false);
        }
        for (i = 0; i < climate.size(); ++i) {
            charSequence = (FormattedCharSequence)climate.get(i);
            graphics.drawString(this.font, charSequence, rightContentX - this.font.width(charSequence) / 2, rightTop + 86 + 11 * i, 0, false);
        }
        graphics.pose().scale(scaleAmount, scaleAmount, scaleAmount);
        graphics.renderItem(this.profileFish, (int)((float)imageX / scaleAmount), (int)((float)(leftTop + 11) / scaleAmount));
        graphics.pose().scale(1.0f / scaleAmount, 1.0f / scaleAmount, 1.0f / scaleAmount);
    }

    public static class FishButton
    extends AbstractButton {
        private static final ResourceLocation slotTex = Tide.resource("textures/gui/journal/fish_border.png");
        private static final ResourceLocation slotHoverTex = Tide.resource("textures/gui/journal/fish_border_select.png");
        private static final ResourceLocation unreadTex = Tide.resource("textures/gui/journal/unread_icon.png");
        private static final ResourceLocation unreadHoverTex = Tide.resource("textures/gui/journal/unread_icon_select.png");
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final JournalLayout.Profile profile;
        private final FishingJournalScreen parent;

        public FishButton(int x, int y, int w, int h, JournalLayout.Profile profile, FishingJournalScreen parent) {
            super(x, y, w, h, GameNarrator.NO_TITLE);
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.profile = profile;
            this.parent = parent;
        }

        public void onPress() {
            if (TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.profile.getFish())) {
                this.parent.openProfile(this.profile);
            }
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            ResourceLocation unreadTexture;
            ResourceLocation texture = this.isMouseOver(mouseX, mouseY) ? slotHoverTex : slotTex;
            graphics.blit(texture, this.x, this.y, 0.0f, 0.0f, this.w, this.h, this.w, this.h);
            if (!this.profile.getFish().isEmpty()) {
                if (!TidePlayerData.CLIENT_DATA.hasFishUnlocked(this.profile.getFish())) {
                    graphics.setColor(0.0f, 0.0f, 0.0f, 1.0f);
                }
                graphics.renderItem(this.profile.getFish(), this.x + 3, this.y + 3);
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!Tide.CONFIG.general.showUnread) {
                return;
            }
            ResourceLocation resourceLocation = unreadTexture = this.isMouseOver(mouseX, mouseY) ? unreadHoverTex : unreadTex;
            if (TidePlayerData.CLIENT_DATA.isUnread(this.profile)) {
                graphics.blit(unreadTexture, this.x - 1, this.y - 1, 0.0f, 0.0f, 7, 7, 7, 7);
            }
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
        }
    }
}

