/*
 * Decompiled with CFR 0.152.
 */
package com.li64.tide;

import com.li64.tide.config.TideConfig;
import com.li64.tide.data.journal.JournalLayout;
import com.li64.tide.data.journal.config.JournalPageCustomData;
import com.li64.tide.data.journal.config.JournalProfileCustomData;
import com.li64.tide.data.journal.config.JournalRemovalCustomData;
import com.li64.tide.platform.Services;
import com.li64.tide.platform.services.TideMainPlatform;
import com.li64.tide.platform.services.TideNetworkPlatform;
import com.li64.tide.registries.TideItems;
import java.util.function.BiConsumer;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tide {
    public static final String MOD_ID = "tide";
    public static final String MOD_NAME = "Tide";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Tide");
    public static final TideMainPlatform PLATFORM = Services.load(TideMainPlatform.class);
    public static final TideNetworkPlatform NETWORK = Services.load(TideNetworkPlatform.class);
    public static TideConfig CONFIG;
    public static JournalLayout JOURNAL;
    public static JournalPageCustomData JOURNAL_PAGE_CUSTOM_DATA;
    public static JournalProfileCustomData JOURNAL_PROFILE_CUSTOM_DATA;
    public static JournalRemovalCustomData JOURNAL_REMOVAL_CUSTOM_DATA;

    public static void init() {
        CONFIG = (TideConfig)AutoConfig.register(TideConfig.class, Toml4jConfigSerializer::new).getConfig();
        JOURNAL = new JournalLayout();
        LOG.info("Initialized Tide mod on {}", (Object)PLATFORM.getPlatformName());
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static CreativeModeTab.Builder getCreativeTab(CreativeModeTab.Builder builder) {
        return builder.title((Component)Component.translatable((String)"itemGroup.tide.main")).icon(() -> new ItemStack((ItemLike)TideItems.ANGELFISH)).displayItems(Tide::displayItems);
    }

    public static void displayItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        TideItems.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }

    public static void onRegisterReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        registry.accept(Tide.resource("journal/pages"), (PreparableReloadListener)JOURNAL_PAGE_CUSTOM_DATA);
        registry.accept(Tide.resource("journal/profiles"), (PreparableReloadListener)JOURNAL_PROFILE_CUSTOM_DATA);
        registry.accept(Tide.resource("journal/removals"), (PreparableReloadListener)JOURNAL_REMOVAL_CUSTOM_DATA);
    }

    static {
        JOURNAL_PAGE_CUSTOM_DATA = new JournalPageCustomData();
        JOURNAL_PROFILE_CUSTOM_DATA = new JournalProfileCustomData();
        JOURNAL_REMOVAL_CUSTOM_DATA = new JournalRemovalCustomData();
    }
}

