/*
 * Decompiled with CFR 0.152.
 */
package net.team_sparks.naligator.fireworks.network;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.team_sparks.naligator.fireworks.TheFireworksMod;
import net.team_sparks.naligator.fireworks.procedures.FlechelProcedure;
import net.team_sparks.naligator.fireworks.procedures.FlecherProcedure;
import net.team_sparks.naligator.fireworks.world.inventory.Recipeguipage0Menu;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record Recipeguipage0ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<Recipeguipage0ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_fireworks", (String)"recipeguipage_0_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Recipeguipage0ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new Recipeguipage0ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<Recipeguipage0ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(Recipeguipage0ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                Recipeguipage0ButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = Recipeguipage0Menu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            FlechelProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            FlecherProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheFireworksMod.addNetworkMessage(TYPE, STREAM_CODEC, Recipeguipage0ButtonMessage::handleData);
    }
}

