/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.AbstractLayout;
import net.minecraft.client.gui.layouts.LayoutElement;

public class DynamicGridWidget
extends AbstractLayout {
    private final List<GridItem> children = new ArrayList<GridItem>();
    private int padding = 0;

    public DynamicGridWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void addChild(AbstractWidget widget, int cellHeight, int cellWidth) {
        this.children.add(new GridItem(cellHeight, cellWidth, widget));
    }

    public void addChild(AbstractWidget widget) {
        this.children.add(new GridItem(-1, -1, widget));
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    private boolean canFit(int gridX, int gridY, int cellWidth, int cellHeight, int optimalCells, boolean[][] grid) {
        if (gridX >= optimalCells || gridY >= optimalCells) {
            return false;
        }
        for (int x = gridX; x < gridX + cellWidth; ++x) {
            for (int y = gridY; y < gridY + cellHeight; ++y) {
                if (x >= grid.length || y >= grid[x].length) {
                    throw new RuntimeException("Impossible to fit widget in grid!");
                }
                if (!grid[x][y]) continue;
                return false;
            }
        }
        return true;
    }

    public void calculateLayout() {
        int totalCells = 0;
        for (GridItem child : this.children) {
            int widgetCells = child.cellWidth() * child.cellHeight();
            totalCells += widgetCells;
        }
        int optimalCells = (int)Math.ceil(Math.sqrt(totalCells));
        int cellWidth = this.width / optimalCells;
        int cellHeight = this.height / optimalCells;
        boolean[][] grid = new boolean[optimalCells][optimalCells];
        int currentX = this.getX();
        int currentY = this.getY();
        for (GridItem child : this.children) {
            boolean isMultiCell;
            int gridX = currentX / cellWidth;
            int gridY = currentY / cellHeight;
            while (!this.canFit(gridX, gridY, Math.abs(child.cellWidth()), Math.abs(child.cellHeight()), optimalCells, grid)) {
                if ((currentX += cellWidth) >= this.width) {
                    currentX = this.getX();
                    currentY += cellHeight;
                }
                gridX = currentX / cellWidth;
                gridY = currentY / cellHeight;
            }
            if (gridX > optimalCells || gridY > optimalCells) {
                throw new RuntimeException("Impossible to fit widget in grid!");
            }
            if (grid[gridX][gridY]) {
                if ((currentX += cellWidth) >= this.width) {
                    currentX = this.getX();
                    currentY += cellHeight;
                }
                gridX = currentX / cellWidth;
                gridY = currentY / cellHeight;
            }
            int thisCellWidth = cellWidth;
            int thisCellHeight = cellHeight;
            boolean bl = isMultiCell = child.cellHeight() > 1 || child.cellWidth() > 1;
            if (child.cellWidth() != -1) {
                thisCellWidth = child.cellWidth() * cellWidth;
            }
            if (child.cellHeight() != -1) {
                thisCellHeight = child.cellHeight() * cellHeight;
            }
            if (isMultiCell) {
                int minX = gridX;
                int minY = gridY;
                int maxX = gridX + child.cellWidth();
                int maxY = gridY + child.cellHeight();
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        grid[x][y] = true;
                    }
                }
            } else {
                grid[gridX][gridY] = true;
            }
            child.widget().setX(currentX);
            child.widget().setY(currentY);
            child.widget().setWidth(thisCellWidth - this.padding * 2);
            child.widget().setHeight(thisCellHeight - this.padding * 2);
            if ((currentX += thisCellWidth) < this.width) continue;
            currentX = this.getX();
            currentY += thisCellHeight;
        }
    }

    public void visitChildren(Consumer<LayoutElement> consumer) {
        this.children.stream().map(GridItem::widget).forEach(consumer);
    }

    public record GridItem(int cellHeight, int cellWidth, AbstractWidget widget) {
    }
}

